import React from "react";
import codissia from "../../assets/images/home/codissia-office.jpg";
import vector1 from "../../assets/images/about/codissia/vector1.png";
import center from "../../assets/images/about/codissia/center.png";

import { motion } from "framer-motion";
import img1 from "../../assets/images/home/Entrance.png";
import img2 from "../../assets/images/home/cdiic.png";
import img3 from "../../assets/images/home/industrialpark.png";
import img4 from "../../assets/images/home/codissia-office.jpg";
import aboutbg from "../../assets/images/home/home__three__about__06.png";

const Codissiainfo = () => {
  const cards = [
    {
      id: 1,
      title: "Pioneering Trade Infrastructure",
      icon: img1,
      des: "CODISSIA was the first association in India to establish a permanent Trade Fair Complex - the CODISSIA Intec Technology Centre in Coimbatore, spanning over 2 lakh sq. ft. It regularly conducts trade fairs across the country to support and promote MSMEs.",
    },
    {
      id: 2,
      title: "Establishing Industrial Parks",
      icon: img3,
      des: "As an initiative for industrial growth of this region, CODISSIA established CODISSIA Industrial Park Ltd., (CIPL) about 360 acres in 2 different locations namely Kallapalayam and Mopperipalayam villages, located in the east of Coimbatore city.",
    },
    {
      id: 3,
      title: "Fostering Defence Innovation",
      icon: img2,
      des: "CODISSIA established the CODISSIA Defence Innovation and Atal Incubation Centre (CDIIC), India’s first Defence Innovation Hub under the iDEX program of DIO.",
    },
    {
      id: 4,
      title: "Advancing Scientific Testing",
      icon: img4,
      des: "For the development of MSMEs of this region, CODISSIA & SIEMA jointly promoted a Scientific Testing Centre namely, Scientific and Industrial Testing and Research Centre (Si’Tarc) in Coimbatore.",
    },
  ];

  // Framer Motion variant
  const popUpVariant = {
    hidden: { opacity: 0, scale: 0.85 },
    visible: (i) => ({
      opacity: 1,
      scale: 1,
      transition: {
        delay: i * 0.2,
        duration: 0.5,
        ease: "easeOut",
      },
    }),
  };

  return (
    <section className="section-padding">
      <div className="mt-3">
        <div className="container">
          <div className="row align-items-center">
            <div className="col-md-12 col-lg-6">
              <div className="codissia-image-wrapper" data-aos="fade-up">
                <div className="codissia-image-wrapper-main">
                  <img className="img-fluid" src={aboutbg}/>
                </div>
                <img
                  className="codissia-office-img img-fluid"
                  src={codissia}
                  alt="CODISSIA Office"
                />
              </div>
            </div>
            <div className="col-md-12 col-lg-6">
              <div className="codissia-content">
                <div className="codissia-info-card" data-aos="fade-up">
                  <p className="codissia-info-text">
                    CODISSIA playing an important role as an association which
                    represents in the Advisory and Consultative Committees at
                    District, State and National Levels for the benefit of the
                    MSMEs of this region.
                  </p>
                </div>
                <div className="codissia-info-card" data-aos="fade-up">
                  <p className="codissia-info-text">
                    CODISSIA provides a platform for networking, knowledge
                    sharing, and business growth opportunities for its members
                    through various initiatives and events.
                  </p>
                </div>
                <div className="codissia-info-card" data-aos="fade-up">
                  <p className="codissia-info-text">
                    The association actively works with government bodies to
                    advocate for policies that support the growth and
                    development of small and medium enterprises in the region.
                  </p>
                </div>
              </div>
            </div>
          </div>

          <div className="worksall-section-area mt-5">
            <img src={center} alt="" className="elementors67 img-fluid" />
            <div className="row">
              {cards.map((item, index) => (
                <motion.div
                  key={item.id}
                  className="col-lg-3 col-md-6 mb-3"
                  custom={index}
                  initial="hidden"
                  whileInView="visible"
                  viewport={{ once: true, amount: 0.3 }}
                  variants={popUpVariant}
                >
                  <div
                    className={`client10-boxarea text-center ${
                      item.id % 2 === 0 ? "positionboxarea" : ""
                    }`}
                  >
                    <div className="client10-icon margin-b20 ts">
                      <img
                        src={vector1}
                        alt=""
                        className="elemnetors64 keyframe3"
                      />
                      <div
                        className="service10-icon ts"
                        style={{ fontSize: "25px", color: "#fff" }}
                      >
                        <img className="img-fluid" src={item.icon} alt="" />
                      </div>
                      <div className="numbericon ts">
                        <p className="font-16 lineh-24 font-ks weight-700 color r ts number-count">
                          {item.id}
                        </p>
                      </div>
                    </div>
                    <a
                      className="font-lora font-20 lineh-20 weight-600 colorhp3 ts d-inline-block margin-b"
                      href="/servicemiddle"
                    >
                      {item.title}
                    </a>
                    <p className="font-ks font-16 lineh-26 weight-500 color-p10 ts">
                      {item.des}
                    </p>
                  </div>
                </motion.div>
              ))}
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default React.memo(Codissiainfo);
