import React, { useContext, useMemo } from "react";
import { Swiper, SwiperSlide } from "swiper/react";
import {
  EffectCoverflow,
  Autoplay,
  Pagination,
  Navigation,
} from "swiper/modules";
import "swiper/css";
import "swiper/css/effect-coverflow";
import "swiper/css/pagination";
import "swiper/css/navigation";
import PropsContext from "../../context/PropsContext";
import ImageLoader from "../ImageLoader";
import { FaChevronLeft, FaChevronRight } from "react-icons/fa";

const HeroSlider = () => {
  const { banners } = useContext(PropsContext);

  const slides = useMemo(() => {
    return banners.length > 0
      ? banners.map((banner, index) => (
          <SwiperSlide key={index} className="swiper-slide">
            <img src={banner.image} alt={`slide-${index}`} />
          </SwiperSlide>
        ))
      : [
          <div key="loading">
            <ImageLoader />
          </div>,
        ];
  }, [banners]);

  return (
    <div className="slider-container">
      <Swiper
        effect="coverflow"
        grabCursor={true}
        centeredSlides={true}
        loop={true}
        slidesPerView={"auto"}
        navigation={{
          nextEl: ".custom-swiper-button-next",
          prevEl: ".custom-swiper-button-prev",
        }}
        coverflowEffect={{
          rotate: 10,
          stretch: 0,
          depth: 100,
          modifier: 1,
          slideShadows: true,
        }}
        autoplay={{ delay: 5000, disableOnInteraction: false }}
        pagination={{ clickable: true }}
        modules={[EffectCoverflow, Autoplay, Pagination, Navigation]}
        className="swiper-container"
      >
        {slides}
      </Swiper>

      {/* Custom Navigation Buttons */}
      <div className="custom-swiper-button-prev">
        <FaChevronLeft />
      </div>
      <div className="custom-swiper-button-next">
        <FaChevronRight />
      </div>
    </div>
  );
};

export default React.memo(HeroSlider) ;
