import React, { useRef } from "react";
import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Pagination, Autoplay } from "swiper/modules";
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";
import "swiper/css/autoplay";
import { FiChevronLeft, FiChevronRight } from "react-icons/fi";
import { FiChevronsRight } from "react-icons/fi";

import services1 from "../../assets/images/home/services-1.jpg";
import services2 from "../../assets/images/home/services-2.jpg";
import services3 from "../../assets/images/home/services-3.jpg";
import services4 from "../../assets/images/home/services-4.jpg";
import services5 from "../../assets/images/home/services-5.jpg";
import services6 from "../../assets/images/home/services-6.jpg";
// Services Provided

import services7 from "../../assets/images/activities/services/services-1.png";
import services8 from "../../assets/images/activities/services/services-2.png";
import services9 from "../../assets/images/activities/services/services-3.png";
import services10 from "../../assets/images/activities/services/services-4.png";
import services11 from "../../assets/images/activities/services/services-5.png";
import services12 from "../../assets/images/activities/services/services-6.png";
import services13 from "../../assets/images/activities/services/services-7.png";
import services14 from "../../assets/images/activities/services/services-8.png";

const services = [
  {
    title: "B2B Meeting",
    description:
      "CODISSIA regularly organizes B2B (Business-to-Business) meetings to facilitate direct interactions between buyers and sellers. These meetings serve as a vital platform for businesses to showcase their products, explore partnership opportunities, and establish new market linkages. In one such impactful event, a High-Level Committee from the Government of India, focusing on electric motors and pumps, visited Coimbatore to engage with key industry leaders. These interactions help strengthen the industrial ecosystem and promote innovation-driven growth.",
    image: services1,
    link: "/services",
  },
  {
    title: "Our Technical Seminar",
    description:
      "Our technical seminars are designed to keep industry professionals, entrepreneurs, and technical experts updated with the latest innovations, policies, and market trends. These seminars cover a wide range of topics, from automation and machinery advancements to government schemes and sustainability practices. Notably, a High-Level Committee of the Government of India recently participated in a seminar focused on the electric motors and pumps sector, highlighting the importance of knowledge-sharing and policy alignment.",
    image: services2,
    link: "/services",
  },
  {
    title: "CSR",
    description:
      "CODISSIA is deeply committed to Corporate Social Responsibility (CSR) and community welfare. Our initiatives focus on education, health, skill development, and environmental sustainability. Through strategic collaborations and funding, we aim to uplift underprivileged communities and contribute meaningfully to social development. Our CSR efforts reflect our belief that true growth is inclusive and sustainable, benefiting not just the industry but society at large.",
    image: services3,
    link: "/services",
  },
  {
    title: "Trade & Industry",
    description:
      "CODISSIA plays a crucial role in promoting trade and industry in the region. The organization actively supports industrial growth through bulletins, trade journals like the 'CODISSIA BULLETIN (Sympathy Journal)', and industry-focused programs. We also organize industrial study tours, helping entrepreneurs gain exposure to best practices and technological advancements. These efforts are aimed at fostering a culture of excellence, competitiveness, and continuous learning among MSMEs and large-scale industries alike.",
    image: services4,
    link: "/services",
  },
  {
    title: "MSME Meeting",
    description:
      "MSME (Micro, Small, and Medium Enterprises) meetings hosted by CODISSIA provide a strategic platform for entrepreneurs and business owners to discuss challenges, share insights, and explore new opportunities. These meetings are essential for fostering innovation, securing financial support, and navigating government policies. MSMEs are vital to India's economic landscape, contributing significantly to employment, exports, and GDP. CODISSIA advocates for their growth by connecting them with industry experts, policymakers, and investors.",
    image: services6,
    link: "/services",
  },
  {
    title: "Trade Fairs",
    description:
      "The CODISSIA Trade Fair Complex in Coimbatore is one of South India's premier destinations for organizing large-scale trade fairs, exhibitions, and industrial showcases. These events attract participants from across India and abroad, offering vast opportunities for networking, brand exposure, and product launches. The facility is equipped with modern infrastructure and expansive halls, making it ideal for both B2B and B2C exhibitions. Trade fairs hosted here have a proven track record of boosting regional commerce and attracting global attention.",
    image: services5,
    link: "/tradefairs",
  },
  {
    title: "Publishes CODISSIA Bulletin, a fortnightly journal",
    description:
      "Stay updated with industry trends, news, and insights through our fortnightly CODISSIA Bulletin, a comprehensive journal for members and stakeholders",
    image: services7,
    link: "/services",
  },
  {
    title: "Assist New Entrepreneurial Guidance",
    description:
      "We provide expert guidance and support to new entrepreneurs, helping them navigate challenges and establish successful businesses.",
    image: services8,
    link: "/services",
  },
  {
    title: "Ancillary development",
    description:
      "We support the growth of ancillary industries by offering resources, infrastructure, and networking opportunities to foster development.",
    image: services9,
    link: "/services",
  },
  {
    title: "Help in resolving Industry problems",
    description:
      "Our team offers expert solutions and mediation to address industry-specific challenges, ensuring smooth operations for businesses.",
    image: services10,
    link: "/services",
  },
  {
    title: "Preparation of Detailed Project Reports (DPRs)",
    description:
      "We assist in creating comprehensive Detailed Project Reports (DPRs) to help businesses plan, secure funding, and execute projects efficiently.",
    image: services11,
    link: "/services",
  },
  {
    title:
      "Industry - Academia Interaction activities for the benefit of students",
    description:
      "We bridge the gap between industry and academia by organizing interactive programs, workshops, and seminars to enhance student learning and employability.",
    image: services12,
    link: "/services",
  },
  {
    title:
      "Publishing books on current topics to educate members and others in general",
    description:
      "We publish informative books on relevant industry topics to keep members and the public informed about the latest trends and best practices.",
    image: services13,
    link: "/services",
  },
  {
    title:
      "Periodically for the benefit of trade and industries of this region",
    description:
      "We conduct regular initiatives, events, and programs aimed at fostering growth and innovation in the trade and industries of the region.",
    image: services14,
    link: "/services",
  },
];

const Services = () => {
  const prevRef = useRef(null);
  const nextRef = useRef(null);

  return (
    <section className="services py-10 relative">
      <div className="container relative">
        <div className="section-title text-center mb-6">
          <h2 className="mb-4">OUR SERVICES</h2>
        </div>

        {/* Custom Navigation */}
        <div className="services__nav services__nav--prev">
          <button ref={prevRef} className="services__btn">
            <FiChevronLeft className="services__icon" />
          </button>
        </div>
        <div className="services__nav services__nav--next">
          <button ref={nextRef} className="services__btn">
            <FiChevronRight className="services__icon" />
          </button>
        </div>

        <Swiper
          modules={[Navigation, Pagination, Autoplay]}
          spaceBetween={10}
          slidesPerView={1}
          loop={true}
          autoplay={{
            delay: 5000,
            disableOnInteraction: false,
          }}
          navigation={{
            prevEl: prevRef.current,
            nextEl: nextRef.current,
          }}
          breakpoints={{
            425: { slidesPerView: 1 },
            768: { slidesPerView: 2 },
            1024: { slidesPerView: 3 },
            1200: { slidesPerView: 4 },
          }}
          className="services-carousel"
          onInit={(swiper) => {
            swiper.params.navigation.prevEl = prevRef.current;
            swiper.params.navigation.nextEl = nextRef.current;
            swiper.navigation.init();
            swiper.navigation.update();
          }}
        >
          {services.map((service, index) => (
            <SwiperSlide key={index}>
              <div
                className="service-card bg-white rounded shadow"
                data-aos="fade-up"
              >
                <img
                  src={service.image}
                  alt={service.title}
                  className="w-full h-52 object-cover rounded-t-md"
                />
                <div className="service-content p-3">
                  <h3 className="text-lg font-semibold">{service.title}</h3>
                  <p className="text-sm text-gray-600">{service.description}</p>
                  <a
                    href={service.link}
                    className="service-link mt-2 inline-block"
                  >
                    Read More{" "}
                    <span>
                      <FiChevronsRight />
                    </span>
                  </a>
                </div>
              </div>
            </SwiperSlide>
          ))}
        </Swiper>
      </div>
    </section>
  );
};

export default React.memo(Services);
