import React, { useState } from "react";
import codissia from "../../assets/images/home/Entrance.png";
import cdiic from "../../assets/images/home/cdiic.png";
import codissiapark from "../../assets/images/home/industrialpark.png";
import complexModalImg from "../../assets/images/home/Teamwork.jpg"; 
import { MdClose } from "react-icons/md";

const StatsSection = () => {
  const [modalData, setModalData] = useState(null);

  const openModal = (data) => {
    setModalData(data);
  };

  const closeModal = () => {
    setModalData(null);
  };

  const statsItems = [
    {
      img: codissia,
      modalImg: complexModalImg, 
      title: "COMPLEX",
      subtitle: "Codissia Trade Fair Complex",
      description: `CODISSIA was the first association in India to establish a permanent Trade Fair Complex - the CODISSIA Intec Technology Centre in Coimbatore, spanning over 2 lakh sq. ft. It regularly conducts trade fairs across the country to support and promote MSMEs.`,
      link: "https://www.codissiacomplex.com/",
    },
    {
      img: cdiic,
      title: "CDIIC",
      subtitle: "CODISSIA DEFENCE INNOVATION AND ATAL INCUBATION CENTRE",
      description: `CODISSIA Defence Innovation and Atal Incubation Centre (CDIIC) is a not-for-profit Section 8 company established under the Companies Act, 2013 on 10th January, 2019 by its founding association – CODISSIA. Supported by Atal Innovation Mission, NITI Aayog and Ministry of Defence.`,
      link: "https://www.cdiic.in/",
    },
    {
      img: codissiapark,
      title: "CIPL",
      subtitle: "Codissia Industrial Park Limited",
      description: `As an initiative for industrial growth of this region, CODISSIA established CODISSIA Industrial Park Ltd., (CIPL) about 360 acres in 2 different locations namely Kallapalayam and Mopperipalayam villages, located in the east of Coimbatore city.`,
      link: "/",
    },
  ];

  return (
    <div className="stats-container mt-5">
      <div className="technology-grid">
        {statsItems.map((item, index) => (
          <div
            className="technology-grid-main"
            key={index}
            data-aos="fade-up"
            onClick={() => openModal(item)}
          >
            <img className="img-fluid" src={item.img} alt={item.title} />
            <div className="text-center technology-grid-item">
              <h5>{item.title}</h5>
              <p>{item.subtitle}</p>
            </div>
          </div>
        ))}
      </div>

      {/* Modal */}
      {modalData && (
        <div className="stats-modal-overlay" onClick={closeModal}>
          <div
            className="stats-modal-wrapper"
            onClick={(e) => e.stopPropagation()}
          >
            <img
              className="img-fluid"
              src={modalData.modalImg || modalData.img} // 👈 use custom modal image if available
              alt={modalData.title}
            />
            <h5>{modalData.title}</h5>
            <p>
              <strong>{modalData.subtitle}</strong>
            </p>
            <p>{modalData.description}</p>
            <div className="flex-column d-flex">
              <a
                href={modalData.link}
                target="_blank"
                rel="noopener noreferrer"
              >
                More Info
              </a>
              <button className="stats-modal-close-btn" onClick={closeModal}>
                <MdClose />
              </button>
            </div>
          </div>
        </div>
      )}
    </div>
  );
};

export default React.memo(StatsSection);
