import React from "react";
import { useNavigate } from "react-router-dom";
import { IoIosPeople } from "react-icons/io";
import starimg from "../../assets/images/members/star.svg";
import Borderbottom from "../Borderbottom";
import {FaArrowRight} from "react-icons/fa";


const Membersinfo = () => {
  const members = [
    {
      id: 1,
      name: "Associate Member",
      description1:
        "Access global networks and industry opportunities with Codissia.",
      description2:
        "Includes mentorship, events, and policy framework involvement.",
    },
    {
      id: 2,
      name: "Industrial Member",
      description1:
        "Boost manufacturing strength with tailored infrastructure support.",
      description2:
        "Includes exhibition access and policy advocacy for industries.",
    },
    {
      id: 3,
      name: "Patron Member",
      description1:
        "Shape strategic direction and join exclusive leadership forums.",
      description2: "Get access to high-level decision-making platforms.",
    },
    {
      id: 4,
      name: "Life Member",
      description1:
        "Life Member: Lifetime benefits, recognition, and exclusive access",
      description2:
        "Enjoy lifelong CODISSIA privileges and priority networking.",
    },
    {
      id: 5,
      name: "Institutional Member",
      description1:
        "Partner with Codissia for research, training, and innovation.",
      description2:
        "For academic and research institutions enabling industry synergy.",
    },
  ];

    const navigate = useNavigate();
  
    const handleBecomeMemberClick = () => {
      navigate("/contactus");
    };

  return (
    <section className="members-info-section">
      <div className="container">
        <Borderbottom />
        <div className="member-grid-container">
          {members.map((member) => (
            <div key={member.id} className="member-card-box">
              <div className="member-card-img">
                <img
                  className="img-fluid member-card-img-star"
                  src={starimg}
                  alt=""
                  srcset=""
                />
              </div>
              <div className="member-icon-wrap">
                <IoIosPeople className="member-add-icon" />
              </div>
              <div className="member-card-content">
                <h3 className="member-card-title">{member.name}</h3>
                <p className="member-card-desc">{member.description1}</p>
                <p className="member-card-desc">{member.description2}</p>
              </div>
            </div>
          ))}
        </div>
        {/* Become a Member Button */}
        <div className="text-center mt-5 become-member-container">
          <p className="fw-bold">
            "Join CODISSIA today and unlock endless opportunities for growth,
            innovation, and industrial networking."
          </p>
          <div className="become-member-wrapper">
          <a className="become-member-btn" onClick={handleBecomeMemberClick}>
              <span className="btn-text">Become a Member</span>
              <span className="btn-icon">
                <FaArrowRight />
              </span>
            </a>
          </div>
        </div>
      </div>
    </section>
  );
};

export default React.memo(Membersinfo);
