import React, { useContext } from "react";
import { Button, Row, Col, Image } from "react-bootstrap";
import { BsCheckCircle, BsXCircle } from "react-icons/bs";
import PropsContext from "../../context/PropsContext";
import { storage } from "../../services/apiServices";
import ImageLoader from "../ImageLoader";

const Notificationinfo = () => {
  const { notifications } = useContext(PropsContext);

  if (!notifications || notifications.length === 0) {
    return (
      <div className="container mt-5">
        {" "}
        <ImageLoader />
      </div>
    );
  }

  return (
    <div className="container mt-5">
      <div className="p-3">
        {notifications.map((note, index) => (
          <Row className="py-4 align-items-center notification-row" key={index}>
            <Col
              xs={10}
              sm={10}
              md={10}
              className=" d-flex align-items-center notification-card-main"
            >
              <div className="notification-card">
                <div className="me-3">
                  <Image
                    src={
                
                       note.image.replace(/^images\//, "")
                     
                    }
                    roundedCircle
                    width={50}
                    height={50}
                    className="border"
                    alt="Notification"
                    
                  />
                </div>
                {/* Content Section */}
                <div className="d-flex flex-column">
                  <h4>{note.name}</h4>
                  <span className="fw-700">{note.description}</span>

                  {note.link && (
                    <a
                      href={note.link}
                      className="text-primary mt-1"
                      target="_blank"
                      rel="noopener noreferrer"
                    >
                      {note.linkText || "View"}
                    </a>
                  )}

                  {note.actions && note.actions.length >= 2 && (
                    <div className="mt-2">
                      <Button variant="success" size="sm" className="me-2">
                        {note.actions[0]} <BsCheckCircle />
                      </Button>
                      <Button variant="danger" size="sm">
                        {note.actions[1]} <BsXCircle />
                      </Button>
                    </div>
                  )}
                </div>
              </div>
            </Col>

            <Col xs={2} sm={2} md={2} className="timeline-col text-start">
              <div className="timeline-item">
                <span className="timeline-dot"></span>
                <div className="timeline-date">{note.date}</div>
              </div>
            </Col>
          </Row>
        ))}
      </div>
    </div>
  );
};

export default Notificationinfo;
