import React, { useRef, useState } from "react";
import logo from "../assets/footer-logo.png";
import {
  FaAngleRight,
  FaMapMarkerAlt,
  FaPhoneAlt,
  FaPlay,
  FaTimes,
} from "react-icons/fa";
import cd from "../assets/cd.png";
import video from "../assets/codissia-video.mp4";
import { Modal } from "react-bootstrap";
import img from "../assets/images/home/Entrance.png";

const Footer = () => {
  const videoRef = useRef(null);
  const [showModal, setShowModal] = useState(false);

  const handleShow = () => {
    setShowModal(true);
  };

  const handleClose = () => {
    videoRef.current.pause();
    setShowModal(false);
  };

  return (
    <footer className="text-light pt-4 footer-main ">
      <div className="container">
        <div className="row">
          {/* Logo Section */}
          <div className="col-md-6 col-lg-3 text-center text-lg-start mb-4">
            <img src={logo} alt="Codissia Logo" className="img-fluid" />
          </div>

          {/* Quick Links */}
          <div className="col-sm-6 col-md-6 col-lg-3 mb-4 footer-main-info">
            <h5 className="footer-title">Quick Links</h5>
            <ul className="list-unstyled footer-links">
              {[
                { name: "Home", href: "/" },
                { name: "Vision & Mission", href: "/vision&mission" },
                { name: "Milestones", href: "/milestones" },
                { name: "Events", href: "/events" },
                { name: "Services", href: "/services" },
                { name: "Membership", href: "/membership" },
                { name: "Bulletins", href: "/bulletins" },
                { name: "TradeFairs", href: "/tradefairs" },
                { name: "Gallery", href: "/gallery" },
                { name: "Contact Us", href: "/contactus" },
              ].map((link, index) => (
                <li key={index}>
                  <a
                    href={link.href}
                    className="text-light text-decoration-none"
                  >
                    <FaAngleRight className="me-2" /> {link.name}
                  </a>
                </li>
              ))}
            </ul>
          </div>

          {/* Contact Us */}
          <div className="col-sm-6 col-md-6 col-lg-3 mb-4 footer-main-info">
            <h5 className="footer-title">Contact Us</h5>
            <a
              href="https://maps.app.goo.gl/nyxK7wtiyaJMRKxc9"
              target="_blank"
              rel="noopener noreferrer"
            >
              <div className="d-flex">
                <p className="mb-1">
                  <FaMapMarkerAlt className="me-2" />
                </p>
                <p>
                  {" "}
                  Codissia, G.D. Naidu Towers,
                  <br />
                  Post Bag No.3827,
                  <br /> Huzur Road,
                  <br />
                  Coimbatore - 641 018,
                  <br />
                  TamilNadu, South India.
                </p>
              </div>
            </a>
          </div>

          {/* Reach Now & Social Media */}
          <div className="col-sm-6 col-md-6 col-lg-3 mb-4 footer-main-info">
            <div>
              <h5 className="footer-title">Reach Now</h5>
              <p className="mb-1">
                <FaPhoneAlt className="me-2" />
                Office : <a href="tel:+91 0422-2222396 ">+91 0422-2222396 </a>
              </p>
              <p className="mb-1">
                <FaPhoneAlt className="me-2" />
                Office : <a href="tel:+91 0422-2222397 ">+91 0422-2222397 </a>
              </p>
              <p className="mb-1">
                <FaPhoneAlt className="me-2" />
                Office : <a href="tel:+91 0422-2222409"> +91 0422-2222409 </a>
              </p>
            </div>

            {/* Video Section */}
            <div className="mt-3 video-section">
              <div
                className="position-relative video-thumbnail"
                onClick={handleShow}
              >
                <div className="ratio ratio-16x9">
                  {/* Replace the bg-dark div with an actual image */}
                  <img
                    src={img}
                    alt="Video thumbnail"
                    className="img-fluid w-100 h-100 object-fit-cover"
                  />
                  <div className="d-flex justify-content-center align-items-center h-100 position-absolute top-0 start-0 w-100">
                    {/* Play button overlay */}
                    <button
                      className="btn btn-light btn-sm"
                      style={{
                        borderRadius: "50%",
                        width: "50px",
                        height: "50px",
                        zIndex: 1, // Ensure it's above the image
                      }}
                    >
                      <FaPlay />
                    </button>
                  </div>
                </div>
              </div>
            </div>

            {/* Video Modal */}
            <Modal show={showModal} className="video-modal" onHide={handleClose} centered size="lg">
              <div className="d-flex justify-content-end align-items-center">
              <button className="btn btn-video me-2" onClick={handleClose}>
                <FaTimes className="" />
              </button>
              </div>
              

              <Modal.Body className="p-1">
                <video ref={videoRef} width="100%" controls autoPlay>
                  <source src={video} type="video/mp4" />
                  Your browser does not support the video tag.
                </video>
              </Modal.Body>
            </Modal>

            {/* Social Media Icons */}
          </div>
        </div>
      </div>

      {/* Footer Bottom */}
      <div className="text-center py-2 footer-bottom">
        <div className="row">
          <div className="col-md-6">
            <div>
              <p className="mb-0">
                © {new Date().getFullYear()} - Codissia. All rights reserved
              </p>
            </div>
          </div>
          <div className="col-md-6">
            <div>
              <p>
                Website designed by
                <a
                  target="_blank"
                  href="https://www.clouddreams.in/"
                  className="text-light text-decoration-none"
                  rel="noopener noreferrer"
                >
                  <img className="footer-cd" src={cd} alt="" />
                </a>
              </p>
            </div>
          </div>
        </div>
      </div>
    </footer>
  );
};

export default Footer;
