import { useEffect, useState } from "react";
import { motion } from "framer-motion";
import { Link } from "react-router-dom";
import { Navbar, Nav, Container, Offcanvas, Dropdown } from "react-bootstrap";
import { FaEnvelope, FaPhone } from "react-icons/fa";
import { TfiAlignRight } from "react-icons/tfi";
import { TfiControlBackward } from "react-icons/tfi";
import logo from "../assets/logo.png";
import icon from "../assets/footer-logo.png";
import { FiArrowRight } from "react-icons/fi";

const Header = () => {
  const [menuOpen, setMenuOpen] = useState(false);
  const [dropdownOpen, setDropdownOpen] = useState(null);
  const [isLoaded, setIsLoaded] = useState(false);
  const [isMobile, setIsMobile] = useState(window.innerWidth <= 768);

  useEffect(() => {
    const handleLoad = () => setIsLoaded(true);
    const handleResize = () => {
      setIsMobile(window.innerWidth <= 768);
    };

    window.addEventListener("load", handleLoad);
    window.addEventListener("resize", handleResize);
    return () => {
      window.removeEventListener("load", handleLoad);
      window.removeEventListener("resize", handleResize);
    };
  }, []);

  const toggleMenu = () => {
    setMenuOpen(!menuOpen);
    if (!menuOpen) {
      setDropdownOpen(null);
    }
  };

  const toggleDropdown = (dropdownName) => {
    if (isMobile) {
      setDropdownOpen(dropdownOpen === dropdownName ? null : dropdownName);
    }
  };

  const handleDropdownEnter = (dropdownName) => {
    if (!isMobile) {
      setDropdownOpen(dropdownName);
    }
  };

  const handleDropdownLeave = () => {
    if (!isMobile) {
      setDropdownOpen(null);
    }
  };

  return (
    <div className="navbar-main">
      <div className="container-fluid top-bar text-white py-2 px-3 d-flex justify-content-center justify-content-sm-between align-items-center">
        <div className="contact-info d-flex align-items-center gap-2">
          <FaEnvelope className="me-2" />
          <a href="mailto:info@codissia.com" className="text-white me-3">
            info@codissia.com
          </a>
          <FaPhone className="me-2" />
          <span>
            {" "}
            <a href="tel:+91 0422-2222409">+91 0422-2222409</a>{" "}
          </span>
        </div>
        <div className="d-none d-sm-block">
          <Link
            className="codissia_members text-white"
            to="https://members.codissia.com/"
            target="_blank"
          >
            CODISSIA MEMBERS |{" "}
            <span className="arrow">
              {" "}
              <FiArrowRight />
            </span>
          </Link>
        </div>
      </div>
      <Navbar expand="lg" variant="dark" className="d-flex flex-column">
        <Container className="d-flex align-items-center navbar-container">
          <Navbar.Brand href="/" className="text-center m-auto">
            <motion.a
              href="/"
              className="text-center m-auto navbar-brand"
              initial={{ opacity: 0, y: 30 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ duration: 1, ease: "easeOut" }}
            >
              <motion.img
                alt="Codissia Logo"
                className=" codissia-logo"
                src={logo}
                whileHover={{ scale: 1.05 }}
                whileTap={{ scale: 0.95 }}
              />
            </motion.a>
          </Navbar.Brand>

          {/* Custom Hamburger Menu */}
          <div className="d-lg-none">
            <button onClick={toggleMenu} className="hamburger-btn">
              <TfiAlignRight className="hamburger-icon" />
            </button>
          </div>

          {/* Offcanvas for Mobile View */}
          <Navbar.Offcanvas
            id="offcanvasNavbar"
            aria-labelledby="offcanvasNavbarLabel"
            placement="end"
            className="custom-offcanvas text-white"
            show={menuOpen}
            onHide={toggleMenu}
          >
            <Offcanvas.Header
              closeButton
              closeVariant="white"
              onClick={toggleMenu}
            >
              <Offcanvas.Title id="offcanvasNavbarLabel">
                <img
                  className="img-fluid mobile-logo"
                  src={logo}
                  alt="Codissia Logo"
                />
              </Offcanvas.Title>
            </Offcanvas.Header>
            <Offcanvas.Body>
              <Nav className="ms-auto d-block d-lg-none flex-column align-items-center">
                <Nav.Link
                  href="/"
                  className="text-white fancy-link"
                  onClick={toggleMenu}
                >
                  <span>HOME </span>
                </Nav.Link>

                {/* Dropdown for "About Us" */}
                <Dropdown
                  align="center"
                  className="about-dropdown"
                  show={dropdownOpen === "about"}
                  onToggle={(isOpen) =>
                    isOpen ? setDropdownOpen("about") : setDropdownOpen(null)
                  }
                >
                  <Dropdown.Toggle
                    variant="link"
                    className="text-white fancy-link"
                    onClick={() => toggleDropdown("about")}
                  >
                    ABOUT US <TfiControlBackward className="dropdown-icon" />
                  </Dropdown.Toggle>
                  <Dropdown.Menu className="dropdown-menu-animate">
                    <Dropdown.Item href="/aboutcodissia" onClick={toggleMenu}>
                      <span>
                        <img className="icon-dropdown" src={icon} alt="" />
                      </span>
                      About Codissia
                    </Dropdown.Item>
                    <Dropdown.Item
                      href="/presidentmessage"
                      onClick={toggleMenu}
                    >
                      <span>
                        <img className="icon-dropdown" src={icon} alt="" />
                      </span>
                      President Message
                    </Dropdown.Item>
                    <Dropdown.Item href="/vision&mission" onClick={toggleMenu}>
                      <span>
                        <img className="icon-dropdown" src={icon} alt="" />
                      </span>
                      vision & mission
                    </Dropdown.Item>
                    <Dropdown.Item href="/officebearers" onClick={toggleMenu}>
                      <span>
                        <img className="icon-dropdown" src={icon} alt="" />
                      </span>
                      Office Bearers
                    </Dropdown.Item>
                    <Dropdown.Item href="/pastpresident" onClick={toggleMenu}>
                      <span>
                        <img className="icon-dropdown" src={icon} alt="" />
                      </span>
                      Past President
                    </Dropdown.Item>
                    <Dropdown.Item href="/seniormembers" onClick={toggleMenu}>
                      <span>
                        <img className="icon-dropdown" src={icon} alt="" />
                      </span>
                      Senior Members
                    </Dropdown.Item>
                    <Dropdown.Item
                      href="/executivemembers"
                      onClick={toggleMenu}
                    >
                      <span>
                        <img className="icon-dropdown" src={icon} alt="" />
                      </span>
                      Executive Members
                    </Dropdown.Item>
                    <Dropdown.Item href="/milestones" onClick={toggleMenu}>
                      <span>
                        <img className="icon-dropdown" src={icon} alt="" />
                      </span>
                      Milestones
                    </Dropdown.Item>
                    <Dropdown.Item href="/roll-of-honour" onClick={toggleMenu}>
                      <span>
                        <img className="icon-dropdown" src={icon} alt="" />
                      </span>
                      Roll of Honour
                    </Dropdown.Item>
                  </Dropdown.Menu>
                </Dropdown>

                {/* Dropdown for "Activities" */}
                <Dropdown
                  align="center"
                  className="about-dropdown"
                  show={dropdownOpen === "activities"}
                  onToggle={(isOpen) =>
                    isOpen
                      ? setDropdownOpen("activities")
                      : setDropdownOpen(null)
                  }
                >
                  <Dropdown.Toggle
                    variant="link"
                    className="text-white fancy-link"
                    onClick={() => toggleDropdown("activities")}
                  >
                    <span>ACTIVITIES </span>{" "}
                    <TfiControlBackward className="dropdown-icon" />
                  </Dropdown.Toggle>
                  <Dropdown.Menu className="dropdown-menu-animate">
                    <Dropdown.Item href="/membersbenefits" onClick={toggleMenu}>
                      <span>
                        <img className="icon-dropdown" src={icon} alt="" />
                      </span>
                      MEMBER BENEFITS
                    </Dropdown.Item>
                    <Dropdown.Item
                      href="/membershipingovtcommittees"
                      onClick={toggleMenu}
                    >
                      <span>
                        <img className="icon-dropdown" src={icon} alt="" />
                      </span>
                      MEMBERSHIP IN GOVT.COMMITTEES
                    </Dropdown.Item>
                    <Dropdown.Item
                      href="/mouwithtechnicalinstitutions"
                      onClick={toggleMenu}
                    >
                      <span>
                        <img className="icon-dropdown" src={icon} alt="" />
                      </span>
                      MOU WITH TECHNICAL INSTITUTIONS
                    </Dropdown.Item>
                  </Dropdown.Menu>
                </Dropdown>

                {/* Dropdown for "Exhibition" */}
                <Dropdown
                  align="center"
                  className="about-dropdown"
                  show={dropdownOpen === "exhibition"}
                  onToggle={(isOpen) =>
                    isOpen
                      ? setDropdownOpen("exhibition")
                      : setDropdownOpen(null)
                  }
                >
                  <Dropdown.Toggle
                    variant="link"
                    className="text-white fancy-link"
                    onClick={() => toggleDropdown("exhibition")}
                  >
                    EXHIBITION <TfiControlBackward className="dropdown-icon" />
                  </Dropdown.Toggle>
                  <Dropdown.Menu className="dropdown-menu-animate">
                    <Dropdown.Item
                      href="https://www.intec.codissia.com/"
                      target="_blank"
                      rel="noopener noreferrer"
                      onClick={toggleMenu}
                    >
                      <span>
                        <img className="icon-dropdown" src={icon} alt="" />
                      </span>
                      INTEC
                    </Dropdown.Item>
                    <Dropdown.Item
                      href="https://www.agriintex.codissia.com/"
                      target="_blank"
                      rel="noopener noreferrer"
                      onClick={toggleMenu}
                    >
                      <span>
                        <img className="icon-dropdown" src={icon} alt="" />
                      </span>
                      AGRIINTEX
                    </Dropdown.Item>
                    <Dropdown.Item
                      href="https://www.buildintec.codissia.com/"
                      target="_blank"
                      rel="noopener noreferrer"
                      onClick={toggleMenu}
                    >
                      <span>
                        <img className="icon-dropdown" src={icon} alt="" />
                      </span>
                      BUILDINTEC
                    </Dropdown.Item>
                    <Dropdown.Item
                      href="https://www.elektrotec.codissia.com/"
                      target="_blank"
                      rel="noopener noreferrer"
                      onClick={toggleMenu}
                    >
                      <span>
                        <img className="icon-dropdown" src={icon} alt="" />
                      </span>
                      ELEKTROTEC
                    </Dropdown.Item>
                    <Dropdown.Item
                      href="https://www.cbf.codissia.com/"
                      target="_blank"
                      rel="noopener noreferrer"
                      onClick={toggleMenu}
                    >
                      <span>
                        <img className="icon-dropdown" src={icon} alt="" />
                      </span>
                      CBF
                    </Dropdown.Item>
                    <Dropdown.Item
                      href="https://www.csf.codissia.com/"
                      target="_blank"
                      rel="noopener noreferrer"
                      onClick={toggleMenu}
                    >
                      <span>
                        <img className="icon-dropdown" src={icon} alt="" />
                      </span>
                      CSF
                    </Dropdown.Item>
                    <Dropdown.Item
                      href="https://www.subcon.codissia.com/"
                      target="_blank"
                      rel="noopener noreferrer"
                      onClick={toggleMenu}
                    >
                      <span>
                        <img className="icon-dropdown" src={icon} alt="" />
                      </span>
                      SUBCON
                    </Dropdown.Item>
                    <Dropdown.Item
                      href="https://www.3pexpo.codissia.com/"
                      target="_blank"
                      rel="noopener noreferrer"
                      onClick={toggleMenu}
                    >
                      <span>
                        <img className="icon-dropdown" src={icon} alt="" />
                      </span>
                      3P EXPO
                    </Dropdown.Item>
                    <Dropdown.Item
                      href="https://www.rawmat.codissia.com/"
                      target="_blank"
                      rel="noopener noreferrer"
                      onClick={toggleMenu}
                    >
                      <span>
                        <img className="icon-dropdown" src={icon} alt="" />
                      </span>
                      RAWMAT INDIA
                    </Dropdown.Item>
                    <Dropdown.Item
                      href="https://www.waterintec.codissia.com/"
                      target="_blank"
                      rel="noopener noreferrer"
                      onClick={toggleMenu}
                    >
                      <span>
                        <img className="icon-dropdown" src={icon} alt="" />
                      </span>
                      WATERINTEC
                    </Dropdown.Item>
                    <Dropdown.Item
                      href="https://www.nstf.codissia.com/"
                      target="_blank"
                      rel="noopener noreferrer"
                      onClick={toggleMenu}
                    >
                      <span>
                        <img className="icon-dropdown" src={icon} alt="" />
                      </span>
                      NSTF
                    </Dropdown.Item>
                  </Dropdown.Menu>
                </Dropdown>

                <Nav.Link
                  href="/membership"
                  className="text-white fancy-link"
                  onClick={toggleMenu}
                >
                  <span>MEMBERSHIP </span>
                </Nav.Link>
                <Nav.Link
                  href="/bulletins"
                  className="text-white fancy-link"
                  onClick={toggleMenu}
                >
                  <span>BULLETINS </span>
                </Nav.Link>
                <Nav.Link
                  href="/gallery"
                  className="text-white fancy-link"
                  onClick={toggleMenu}
                >
                  <span>GALLERY </span>
                </Nav.Link>
                <Dropdown
                  align="center"
                  className="about-dropdown"
                  show={dropdownOpen === "membership forms"}
                  onToggle={() =>
                    setDropdownOpen(
                      dropdownOpen === "membership forms"
                        ? null
                        : "membership forms"
                    )
                  }
                >
                  <Dropdown.Toggle variant="link" className="text-white">
                    MEMBERSHIP FORMS{" "}
                    <TfiControlBackward className="dropdown-icon" />
                  </Dropdown.Toggle>

                  <Dropdown.Menu className="dropdown-menu-animate">
                    <Dropdown.Item
                      href="/PDF/Membership Application 2025.pdf"
                      target="_blank"
                      rel="noopener noreferrer"
                    >
                      <span>
                        <img className="icon-dropdown" src={icon} alt="icon" />
                      </span>
                      APPLICATION
                    </Dropdown.Item>

                    <Dropdown.Item
                      href="/PDF/Member Data Base Form 2025.pdf"
                      target="_blank"
                      rel="noopener noreferrer"
                    >
                      <span>
                        <img className="icon-dropdown" src={icon} alt="icon" />
                      </span>
                      DATA BASE
                    </Dropdown.Item>

                    <Dropdown.Item
                      href="/PDF/Appointment of Authorised Representative.pdf"
                      target="_blank"
                      rel="noopener noreferrer"
                    >
                      <span>
                        <img className="icon-dropdown" src={icon} alt="icon" />
                      </span>
                      AUTHORISED REPRESENTATIVE
                    </Dropdown.Item>

                    <Dropdown.Item
                      href="/PDF/REQUIRED COPY OF DOCUMENTS WITH APPLICATION.pdf"
                      target="_blank"
                      rel="noopener noreferrer"
                    >
                      <span>
                        <img className="icon-dropdown" src={icon} alt="icon" />
                      </span>
                      DOCUMENTS WITH APPLICATION
                    </Dropdown.Item>
                  </Dropdown.Menu>
                </Dropdown>

                <Nav.Link
                  href="/contactus"
                  className="text-white fancy-link"
                  onClick={toggleMenu}
                >
                  <span>CONTACT US </span>
                </Nav.Link>
                <Nav.Link
                  target="_blank"
                  href="https://members.codissia.com/"
                  className="text-white d-block d-lg-none"
                >
                  BECOME MEMBER
                </Nav.Link>
              </Nav>
            </Offcanvas.Body>
          </Navbar.Offcanvas>

          {/* Horizontal navigation for larger screens */}
          <Nav className="d-none d-lg-flex justify-content-center gap-1 gap-xl-3">
            <Nav.Link href="/" className="text-white fancy-link">
              <span> HOME </span>
            </Nav.Link>

            {/* Dropdown for "About Us" */}
            <Dropdown
              align="center"
              className="about-dropdown"
              show={dropdownOpen === "about"}
              onMouseEnter={() => handleDropdownEnter("about")}
              onMouseLeave={handleDropdownLeave}
            >
              <Dropdown.Toggle
                variant="link"
                className="text-white"
                onClick={() => isMobile && toggleDropdown("about")}
              >
                ABOUT US <TfiControlBackward className="dropdown-icon" />
              </Dropdown.Toggle>
              <Dropdown.Menu className="dropdown-menu-animate">
                <Dropdown.Item href="/aboutcodissia">
                  <span>
                    <img className="icon-dropdown" src={icon} alt="" />
                  </span>
                  About Codissia
                </Dropdown.Item>
                <Dropdown.Item href="/presidentmessage">
                  <span>
                    <img className="icon-dropdown" src={icon} alt="" />
                  </span>
                  President Message
                </Dropdown.Item>
                <Dropdown.Item href="/vision&mission">
                  <span>
                    <img className="icon-dropdown" src={icon} alt="" />
                  </span>
                  vision & mission
                </Dropdown.Item>
                <Dropdown.Item href="/officebearers">
                  <span>
                    <img className="icon-dropdown" src={icon} alt="" />
                  </span>
                  Office Bearers
                </Dropdown.Item>
                <Dropdown.Item href="/pastpresident">
                  <span>
                    <img className="icon-dropdown" src={icon} alt="" />
                  </span>
                  Past President
                </Dropdown.Item>
                <Dropdown.Item href="/seniormembers">
                  <span>
                    <img className="icon-dropdown" src={icon} alt="" />
                  </span>
                  Senior Members
                </Dropdown.Item>
                <Dropdown.Item href="/executivemembers">
                  <span>
                    <img className="icon-dropdown" src={icon} alt="" />
                  </span>
                  Executive Members
                </Dropdown.Item>
                <Dropdown.Item href="/milestones">
                  <span>
                    <img className="icon-dropdown" src={icon} alt="" />
                  </span>
                  Milestones
                </Dropdown.Item>
                <Dropdown.Item href="/roll-of-honour">
                  <span>
                    <img className="icon-dropdown" src={icon} alt="" />
                  </span>
                  Roll of Honour
                </Dropdown.Item>
              </Dropdown.Menu>
            </Dropdown>

            {/* Dropdown for "Activities" */}
            <Dropdown
              align="center"
              className="about-dropdown"
              show={dropdownOpen === "activities"}
              onMouseEnter={() => handleDropdownEnter("activities")}
              onMouseLeave={handleDropdownLeave}
            >
              <Dropdown.Toggle variant="link" className="text-white">
                <span>ACTIVITIES </span>{" "}
                <TfiControlBackward className="dropdown-icon" />
              </Dropdown.Toggle>
              <Dropdown.Menu className="dropdown-menu-animate">
                <Dropdown.Item href="/membersbenefits">
                  <span>
                    <img className="icon-dropdown" src={icon} alt="" />
                  </span>
                  MEMBER BENEFITS
                </Dropdown.Item>
                <Dropdown.Item href="/membershipingovtcommittees">
                  <span>
                    <img className="icon-dropdown" src={icon} alt="" />
                  </span>
                  MEMBERSHIP IN GOVT.COMMITTEES
                </Dropdown.Item>
                <Dropdown.Item href="/mouwithtechnicalinstitutions">
                  <span>
                    <img className="icon-dropdown" src={icon} alt="" />
                  </span>
                  MOU WITH TECHNICAL INSTITUTIONS
                </Dropdown.Item>
              </Dropdown.Menu>
            </Dropdown>

            {/* Dropdown for "Exhibition" */}
            <Dropdown
              align="center"
              className="about-dropdown"
              show={dropdownOpen === "exhibition"}
              onMouseEnter={() => handleDropdownEnter("exhibition")}
              onMouseLeave={handleDropdownLeave}
            >
              <Dropdown.Toggle variant="link" className="text-white">
                EXHIBITION <TfiControlBackward className="dropdown-icon" />
              </Dropdown.Toggle>
              <Dropdown.Menu className="dropdown-menu-animate">
                <Dropdown.Item
                  href="https://www.intec.codissia.com/"
                  target="_blank"
                  rel="noopener noreferrer"
                >
                  <span>
                    <img className="icon-dropdown" src={icon} alt="" />
                  </span>
                  INTEC
                </Dropdown.Item>
                <Dropdown.Item
                  href="https://www.agriintex.codissia.com/"
                  target="_blank"
                  rel="noopener noreferrer"
                >
                  <span>
                    <img className="icon-dropdown" src={icon} alt="" />
                  </span>
                  AGRIINTEX
                </Dropdown.Item>
                <Dropdown.Item
                  href="https://www.buildintec.codissia.com/"
                  target="_blank"
                  rel="noopener noreferrer"
                >
                  <span>
                    <img className="icon-dropdown" src={icon} alt="" />
                  </span>
                  BUILDINTEC
                </Dropdown.Item>
                <Dropdown.Item
                  href="https://www.elektrotec.codissia.com/"
                  target="_blank"
                  rel="noopener noreferrer"
                >
                  <span>
                    <img className="icon-dropdown" src={icon} alt="" />
                  </span>
                  ELEKTROTEC
                </Dropdown.Item>
                <Dropdown.Item
                  href="https://www.cbf.codissia.com/"
                  target="_blank"
                  rel="noopener noreferrer"
                >
                  <span>
                    <img className="icon-dropdown" src={icon} alt="" />
                  </span>
                  CBF
                </Dropdown.Item>
                <Dropdown.Item
                  href="https://www.csf.codissia.com/"
                  target="_blank"
                  rel="noopener noreferrer"
                >
                  <span>
                    <img className="icon-dropdown" src={icon} alt="" />
                  </span>
                  CSF
                </Dropdown.Item>
                <Dropdown.Item
                  href="https://www.subcon.codissia.com/"
                  target="_blank"
                  rel="noopener noreferrer"
                >
                  <span>
                    <img className="icon-dropdown" src={icon} alt="" />
                  </span>
                  SUBCON
                </Dropdown.Item>
                <Dropdown.Item
                  href="https://www.3pexpo.codissia.com/"
                  target="_blank"
                  rel="noopener noreferrer"
                >
                  <span>
                    <img className="icon-dropdown" src={icon} alt="" />
                  </span>
                  3P EXPO
                </Dropdown.Item>
                <Dropdown.Item
                  href="https://www.rawmat.codissia.com/"
                  target="_blank"
                  rel="noopener noreferrer"
                >
                  <span>
                    <img className="icon-dropdown" src={icon} alt="" />
                  </span>
                  RAWMAT INDIA
                </Dropdown.Item>
                <Dropdown.Item
                  href="https://www.waterintec.codissia.com/"
                  target="_blank"
                  rel="noopener noreferrer"
                >
                  <span>
                    <img className="icon-dropdown" src={icon} alt="" />
                  </span>
                  WATERINTEC
                </Dropdown.Item>
                <Dropdown.Item
                  href="https://www.nstf.codissia.com/"
                  target="_blank"
                  rel="noopener noreferrer"
                >
                  <span>
                    <img className="icon-dropdown" src={icon} alt="" />
                  </span>
                  NSTF
                </Dropdown.Item>
              </Dropdown.Menu>
            </Dropdown>

            <Nav.Link href="/membership" className="text-white fancy-link">
              <span>MEMBERSHIP </span>
            </Nav.Link>
            <Nav.Link href="/bulletins" className="text-white fancy-link">
              <span>BULLETINS </span>
            </Nav.Link>
            <Nav.Link href="/gallery" className="text-white fancy-link">
              <span>GALLERY </span>
            </Nav.Link>

            {/* Dropdown for "Exhibition" */}
            <Dropdown
              align="center"
              className="about-dropdown"
              show={dropdownOpen === "membership forms"}
              onMouseEnter={() => handleDropdownEnter("membership forms")}
              onMouseLeave={handleDropdownLeave}
            >
              <Dropdown.Toggle variant="link" className="text-white">
                MEMBERSHIP FORMS{" "}
                <TfiControlBackward className="dropdown-icon" />
              </Dropdown.Toggle>

              <Dropdown.Menu className="dropdown-menu-animate">
                <Dropdown.Item
                  href="/PDF/Membership Application 2025.pdf"
                  target="_blank"
                  rel="noopener noreferrer"
                >
                  <span>
                    <img className="icon-dropdown" src={icon} alt="icon" />
                  </span>
                  APPLICATION
                </Dropdown.Item>

                <Dropdown.Item
                  href="/PDF/Member Data Base Form 2025.pdf"
                  target="_blank"
                  rel="noopener noreferrer"
                >
                  <span>
                    <img className="icon-dropdown" src={icon} alt="icon" />
                  </span>
                  DATA BASE
                </Dropdown.Item>

                <Dropdown.Item
                  href="/PDF/Appointment of Authorised Representative.pdf"
                  target="_blank"
                  rel="noopener noreferrer"
                >
                  <span>
                    <img className="icon-dropdown" src={icon} alt="icon" />
                  </span>
                  AUTHORISED REPRESENTATIVE
                </Dropdown.Item>

                <Dropdown.Item
                  href="/PDF/REQUIRED COPY OF DOCUMENTS WITH APPLICATION.pdf"
                  target="_blank"
                  rel="noopener noreferrer"
                >
                  <span>
                    <img className="icon-dropdown" src={icon} alt="icon" />
                  </span>
                  DOCUMENTS WITH APPLICATION
                </Dropdown.Item>
              </Dropdown.Menu>
            </Dropdown>

            <Nav.Link href="/contactus" className="text-white fancy-link">
              <span> CONTACT US</span>
            </Nav.Link>

            <Nav.Link
              target="_blank"
              href="https://members.codissia.com/"
              className="text-white d-block d-lg-none"
            >
              Become Member
            </Nav.Link>
          </Nav>
        </Container>
      </Navbar>
    </div>
  );
};

export default Header;
