import React from "react";
import { motion } from "framer-motion";
// import Borderbottom from '../components/Borderbottom'
import Map from "../components/contact/Map";
import ContactDetails from "../components/contact/ContactDetails";
import ContactForm from "../components/contact/Contactform";
import BannerWithBreadcrumbs from "../components/Breadcrumbs";
import ContactAddress from "../components/contact/ContactAddress";
const  ContactPage =()=> {
  // Animation variants
  const leftVariants = {
    hidden: { opacity: 0, x: -50 },
    visible: { opacity: 1, x: 0, transition: { duration: 0.5 } },
  };

  const rightVariants = {
    hidden: { opacity: 0, x: 50 },
    visible: { opacity: 1, x: 0, transition: { duration: 0.5 } },
  };

  return (
    <>
    <BannerWithBreadcrumbs/>
    {/* <Borderbottom/> */}
      <div className="mt-5">
        <div className="section contact-form-main">
          <div className="container">
            <div className="row d-flex justify-content-center align-items-center">
              <motion.div
                className="col-md-6 order-2 order-md-1"
                initial="hidden"
                animate="visible"
                variants={leftVariants}
              >
                <div className="contact-form-row">
                <ContactAddress/>
                </div>
              </motion.div>

              <motion.div
                className="col-md-6 order-1 order-md-2"
                initial="hidden"
                animate="visible"
                variants={rightVariants}
              >
                <Map />
              </motion.div>
            </div>
          </div>
        </div>

        <motion.div
          className="container"
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ delay: 0.3 }}
        >
          <div className="row mt-5">
            <ContactDetails />
          </div>
        </motion.div>
      </div>
    </>
  );
}

export default ContactPage