import React from "react";
import { motion } from "framer-motion"; 
import services1 from "../assets/images/home/services-1.jpg";
import services2 from "../assets/images/home/services-2.jpg";
import services3 from "../assets/images/home/services-3.jpg";
import services4 from "../assets/images/home/services-4.jpg";
import services5 from "../assets/images/home/services-5.jpg";
import services6 from "../assets/images/home/services-6.jpg";
// Services Provided

import services7 from "../assets/images/activities/services/services-1.png";
import services8 from "../assets/images/activities/services/services-2.png";
import services9 from "../assets/images/activities/services/services-3.png";
import services10 from "../assets/images/activities/services/services-4.png";
import services11 from "../assets/images/activities/services/services-5.png";
import services12 from "../assets/images/activities/services/services-6.png";
import services13 from "../assets/images/activities/services/services-7.png";
import services14 from "../assets/images/activities/services/services-8.png";

import Borderbottom from "../components/Borderbottom";
import BannerWithBreadcrumbs from "../components/Breadcrumbs";

const ServicesPage = () => {
  const services = [
    {
      title: "B2B Meeting",
      description:
        "CODISSIA organizes B2B meetings to connect buyers and sellers, fostering business opportunities and partnerships.",
      image: services1,
      link: "/services/b2b-meeting",
    },
    {
      title: "Technical Seminar",
      description:
        "Our seminars update industry professionals on innovations, policies, and market trends in various sectors.",
      image: services2,
      link: "/services/technical-seminar",
    },
    {
      title: "CSR Initiatives",
      description:
        "We support community welfare projects focusing on education, health, skill development, and sustainability.",
      image: services3,
      link: "/services/csr",
    },
    {
      title: "Trade & Industry Support",
      description:
        "We promote trade and industry growth through bulletins, journals, and industry-focused programs.",
      image: services4,
      link: "/services/trade-industry",
    },
    {
      title: "MSME Meetings",
      description:
        "Our MSME meetings offer a platform for entrepreneurs to discuss challenges, share insights, and explore opportunities.",
      image: services5,
      link: "/services/msme-meeting",
    },
    {
      title: "Trade Fairs",
      description:
        "Our Trade Fair Complex hosts large-scale exhibitions, offering networking, brand exposure, and product launches.",
      image: services6,
      link: "/services/trade-fairs",
    },
    {
      title: "Publishes CODISSIA Bulletin, a fortnightly journal",
      description:
        "Stay updated with industry trends, news, and insights through our fortnightly CODISSIA Bulletin, a comprehensive journal for members and stakeholders",
      image: services7,
      link: "/services/trade-fairs",
    },
    {
      title: "Assist New Entrepreneurial Guidance",
      description:
        "We provide expert guidance and support to new entrepreneurs, helping them navigate challenges and establish successful businesses.",
      image: services8,
      link: "/services/trade-fairs",
    },
    {
      title: "Ancillary development",
      description:
        "We support the growth of ancillary industries by offering resources, infrastructure, and networking opportunities to foster development.",
      image: services9,
      link: "/services/trade-fairs",
    },
    {
      title: "Help in resolving Industry problems",
      description:
        "Our team offers expert solutions and mediation to address industry-specific challenges, ensuring smooth operations for businesses.",
      image: services10,
      link: "/services/trade-fairs",
    },
    {
      title: "Preparation of Detailed Project Reports (DPRs)",
      description:
        "We assist in creating comprehensive Detailed Project Reports (DPRs) to help businesses plan, secure funding, and execute projects efficiently.",
      image: services11,
      link: "/services/trade-fairs",
    },
    {
      title: "Industry - Academia Interaction activities for the benefit of students",
      description:
        "We bridge the gap between industry and academia by organizing interactive programs, workshops, and seminars to enhance student learning and employability.",
      image: services12,
      link: "/services/trade-fairs",
    },
    {
      title: "Publishing books on current topics to educate members and others in general",
      description:
        "We publish informative books on relevant industry topics to keep members and the public informed about the latest trends and best practices.",
      image: services13,
      link: "/services/trade-fairs",
    },
    {
      title: "Periodically for the benefit of trade and industries of this region",
      description:
        "We conduct regular initiatives, events, and programs aimed at fostering growth and innovation in the trade and industries of the region.",
      image: services14,
      link: "/services/trade-fairs",
    },
   
 
  ];

  return (
    <>
    <BannerWithBreadcrumbs/>
  
    <section className="tradefairs-section">
    <Borderbottom/>
      <div className="container mt-5">
        <div className="row">
          {services.map((service, index) => (
            <motion.div
              key={index}
              className="col-md-6 col-lg-4 mb-4"
              initial={{ opacity: 0, x: -100 }} 
              animate={{ opacity: 1, x: 0 }} 
              transition={{
                duration: 0.5,
                delay: index * 0.2, 
                ease: "easeOut", 
              }}
            >
              <div className="event-card">
                <a href={service.link}>
                  <motion.img
                    src={service.image}
                    alt={service.title}
                    className="event-image rounded-t-md w-full object-cover h-52"
                    initial={{ scale: 0.95 }} 
                    whileHover={{ scale: 1. }} 
                    transition={{ type: "spring", stiffness: 300 }} 
                  />
                </a>
                <div className="event-content-services ps-3">
                  <h3 className="event-title font-semibold text-xl">{service.title}</h3>
                  <p className="event-desc text-gray-600 text-sm mt-2">{service.description}</p>
                </div>
              </div>
            </motion.div>
          ))}
        </div>
      </div>
    </section>
    </>

  );
};

export default  React.memo(ServicesPage);
