import React from "react";
import { motion } from "framer-motion";

import INTEC from "../assets/images/tradefairs/1.jpg";
import AGRIINTEX from "../assets/images/tradefairs/2.jpg";
import BUILDINTEC from "../assets/images/tradefairs/3.jpg";
import ELEKTROTEC from "../assets/images/tradefairs/5.jpg";
import CBF from "../assets/images/tradefairs/8.jpg";
import COIMBATORESHOPPINGFESTIVAL from "../assets/images/tradefairs/6.jpg";
import SUBCON from "../assets/images/tradefairs/4.jpg";
import PEXPO from "../assets/images/tradefairs/10.jpg";
import RAWMATINDIA from "../assets/images/tradefairs/7.jpg";
import WATERINTEC from "../assets/images/tradefairs/11.jpg";
import EDUINTEC from "../assets/images/tradefairs/9.jpg";


import Borderbottom from "../components/Borderbottom";
import BannerWithBreadcrumbs from "../components/Breadcrumbs";

const tradefairData = [
  {
    title: "INTEC",
    description:
      "Industrial Trade Fair since 1988 showcasing cutting-edge manufacturing technologies",
    link: "https://www.intec.codissia.com/",
    image: INTEC,
  },
  {
    title: "AGRI INTEX",
    description:
      "Agriculture Trade Fair featuring the latest in farming equipment and techniques",
    link: "https://agriintex.codissia.com/",
    image: AGRIINTEX,
  },
  {
    title: "BUILD INTEC",
    description:
      "Building and Construction Trade Fair with innovative construction solutions",
    link: "https://www.buildintec.codissia.com/",
    image: BUILDINTEC,
  },
    {
    title: "ELEKTROTEC",
    description:
      "Electrical and Electronics Fair showcasing latest technologies",
    link: "https://www.elektrotec.codissia.com/",
    image: ELEKTROTEC,
  },
    {
    title: "CBF",
    description:
      "Literary event celebrating books and knowledge sharing",
    link: "https://www.cbf.codissia.com/",
    image: CBF,
  },
   {
    title: "COIMBATORE SHOPPING FESTIVAL",
    description:
      "Consumer Fair offering diverse products and shopping experiences",
    link: "https://www.csf.codissia.com/",
    image: COIMBATORESHOPPINGFESTIVAL,
  },
    {
    title: "SUBCON",
    description: "Subcontracting Fair for industrial outsourcing solutions",
    link: "https://www.subcon.codissia.com/",
    image: SUBCON,
  },
   {
    title: "3P EXPO",
    description: "Paper Printing and Packaging fair for packaging solutions",
    link: "https://www.3pexpo.codissia.com/",
    image: PEXPO,
  },
    {
    title: "RAW MAT INDIA",
    description: "Raw Material Fair for industrial materials and supplies",
    link: "https://www.rawmat.codissia.com/",
    image: RAWMATINDIA,
  },
  {
    title: "WATER INTEC",
    description:
      "Water & Waste Water Technologies Fair promoting sustainable water management",
    link: "https://www.waterintec.codissia.com/",
    image: WATERINTEC,
  },
  {
    title: "EDU INTEC",
    description: "Futuristic Learning Aids fair for educational technologies",
    link: "https://www.nstf.codissia.com/",
    image: EDUINTEC,
  },
];

const Tradefairs = () => {
  return (
    <>
      <BannerWithBreadcrumbs />
      <section className="tradefairs-section py-5">
        <Borderbottom />
        <div className="container mt-5">
          <div className="row">
            {tradefairData.map((event, index) => (
              <div className="col-12 col-md-6 col-lg-4 mb-4" key={index}>
                <motion.div
                  initial={{ y: -50, opacity: 0 }}
                  whileInView={{ y: 0, opacity: 1 }}
                  transition={{ duration: 0.5, delay: index * 0.2 }}
                  className="h-100"
                >
                  <div className="event-card text-center p-3 bg-white rounded shadow h-100 d-flex flex-column justify-content-between">
                    <a
                      href={event.link}
                      target="_blank"
                      rel="noopener noreferrer"
                    >
                      <img
                        src={event.image}
                        alt={`${event.title} Event`}
                        className="img-fluid mb-3"
                      />
                    </a>
                    <div>
                      <h5 className="text-danger fw-bold mb-2">
                        {event.title}
                      </h5>
                      
                      <p className="text-muted small">{event.description}</p>
                    </div>
                  </div>
                </motion.div>
              </div>
            ))}
          </div>
        </div>
      </section>
    </>
  );
};

export default  React.memo(Tradefairs);
