import React from "react";
import Slider from "react-slick";
import "slick-carousel/slick/slick.css";
import "slick-carousel/slick/slick-theme.css";
import agriintex from "../assets/images/tradefairs/agriintex.png";
import buildintec from "../assets/images/tradefairs/buildintec.png";
import elektrotec from "../assets/images/tradefairs/elektrotec.png";
import subcon from "../assets/images/tradefairs/subcon.png";

const Tradefairslider = () => {
  const settings = {
    dots: true,
    infinite: true,
    speed: 500,
    slidesToShow: 1,
    slidesToScroll: 1,
    autoplay: true,
    autoplaySpeed: 3000,
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 1,
        },
      },
      {
        breakpoint: 768,
        settings: {
          slidesToShow: 1,
        },
      },
    ],
  };

  const tradefairData = [
    {
      image: buildintec,
      vente: "Builtintec 2025",
      date: "April 18-21, 2025",
      comments:
        "Innovative solutions for the building and construction industry.",
      description:
        "Experience cutting-edge technologies and sustainables practices shaping the future of infrastructure.",
      link: "https://www.buildintec.codissia.com/",
    },
    {
      image: agriintex,
      vente: "Agriintex 2025",
      date: "April 20, 2025",
      comments: "Open for all industries and international participants.",
      description:
        "Join us for a global showcase of agriculture, technology, and sustainability solutions.",
      link: "https://agriintex.codissia.com/",
    },

    {
      image: elektrotec,
      vente: "Elektrotec 2025",
      date: "July 20, 2025",
      comments: "Electrical and industrial automation solutions expo.",
      description:
        "Showcasing electrical, automation, and power systems innovations for industrial advancement.",
      link: "https://www.elektrotec.codissia.com/",
    },
    {
      image: subcon,
      vente: "Subcon 2025",
      date: "August 05, 2025",
      comments:
        "Focused on job sourcing and outsourcing in the manufacturing sector.",
      description:
        "An exclusive platform for subcontracting, outsourcing, and job work solutions connecting manufacturers and vendors.",
      link: "https://www.subcon.codissia.com/",
    },
  ];

  return (
    <div className="container">
      <div className="tradefair-slider-wrapper">
        <div className="tradefair-slider-container">
          <Slider {...settings}>
            {tradefairData.map((fair, index) => (
              <div key={index} className="tradefair-slide-item">
                <div className="tradefair-image-container">
                  <img
                    src={fair.image}
                    alt={fair.vente}
                    className="tradefair-slide-image"
                  />
                </div>
                <div className="tradefair-content">
                  <h3 className="tradefair-title">{fair.vente}</h3>
                  <p className="tradefair-date">{fair.date}</p>
                
                  
                </div>
              </div>
            ))}
          </Slider>
        </div>
      </div>
    </div>
  );
};

export default  React.memo(Tradefairslider);
