<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Project;
use App\Models\Category;
use App\Models\Employee;

class ApiController extends Controller
{

    public function employee()
    {
        $employee = Employee::all();
        
        return response()->json(['success' => true, 'data' => $employee]);
    }

    public function project()
    {
        $projects = Project::with('category', 'employee')->get();
        return response()->json(['success' => true, 'data' => $projects]);
    }
    
     public function getEmployeeDetails(Request $request)
    {
        
       $user = $request->user;

    // Manually fetch the employee details from the Employee table
    $employee = Employee::where('name', $user)->first();

        // Return the employee details in the response
        return response()->json([
            'success' => true,
            'employee' => $employee
        ], 200);
    }
}
