<?php
namespace App\Http\Controllers;

use App\Forms\FormBuilder;
use App\Models\Category;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ExampleController extends Controller
{
    // Display the form for creating a new resource
    public function create($module)
    {
        $fields = FormBuilder::getFields($module);
        return view('form-template', compact('fields', 'module'));
    }

    // Store a newly created resource in storage
    public function store(Request $request, $module)
    {
        $fields = FormBuilder::getFields($module);
        $validationRules = array_column(array_column($fields, 'validation'), 'validation', 'name');

        $validator = Validator::make($request->all(), $validationRules);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        // Create or update the model
        $modelClass = $this->getModelClass($module);
        $modelClass::create($request->all());

        return redirect()->route('module.index', $module)->with('success', ucfirst($module) . ' created successfully.');
    }

    // Display the form for editing the specified resource
    public function edit($module, $id)
    {
        $fields = FormBuilder::getFields($module);
        $modelClass = $this->getModelClass($module);
        $model = $modelClass::findOrFail($id);
        return view('form-template', compact('fields', 'module', 'model'));
    }

    // Update the specified resource in storage
    public function update(Request $request, $module, $id)
    {
        $fields = FormBuilder::getFields($module);
        $validationRules = array_column(array_column($fields, 'validation'), 'validation', 'name');

        $validator = Validator::make($request->all(), $validationRules);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $modelClass = $this->getModelClass($module);
        $model = $modelClass::findOrFail($id);
        $model->update($request->all());

        return redirect()->route('module.index', $module)->with('success', ucfirst($module) . ' updated successfully.');
    }

    // Remove the specified resource from storage
    public function destroy($module, $id)
    {
        $modelClass = $this->getModelClass($module);
        $model = $modelClass::findOrFail($id);
        $model->delete();

        return redirect()->route('module.index', $module)->with('success', ucfirst($module) . ' deleted successfully.');
    }

    // Display a listing of the resource
    public function index($module)
    {
        $modelClass = $this->getModelClass($module);
        $models = $modelClass::all();
        return view('index-template', compact('models', 'module'));
    }

    // Helper method to get the model class name
    protected function getModelClass($module)
    {
        $models = [
            'project' => \App\Models\Project::class,
            'category' => \App\Models\Category::class,
        ];

        return $models[$module] ?? \App\Models\Project::class; // Default to Project model
    }
}
