<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Project;
use App\Models\Category;
use App\Models\Employee;

class ProjectController extends Controller
{
    //
    public function index()
    {
        $projects = Project::all();
        return view('projects.list', compact('projects'));
    }
    public function add()
    {
        $categories = Category::all();
        $employees = Employee::all();
        return view('projects.add', compact('categories', 'employees'));
    }
    public function store(Request $request)
    {
        // Validate the input
        $request->validate([
            'id' => 'nullable|exists:projects,id', // Optional: If updating, ensure the ID exists
            'name' => 'required|string|max:255',
            'category_id' => 'required|exists:categories,id',
            'link' => 'required|url',
            'type' => 'required|string',
            'cover_img' => 'nullable|image|mimes:jpeg,png,jpg',
            'img' => 'nullable|image|mimes:jpeg,png,jpg',
            'languages' => 'required|string',
            'employee_id' => 'required|exists:employees,id',
        ]);

        // Handle file uploads and use the existing image if not uploaded
        $coverImgPath = $request->hasFile('cover_img')
            ? $request->file('cover_img')->store('assets/cover_images', 'public')
            : Project::find($request->id)->cover_img ?? null;

        $imgPath = $request->hasFile('img')
            ? $request->file('img')->store('assets/image', 'public')
            : Project::find($request->id)->img ?? null;

        // Use updateOrCreate to handle both update and create
        $project = Project::updateOrCreate(
            ['id' => $request->id], // Condition to find the existing record or create a new one
            [
                'name' => $request->name,
                'category_id' => $request->category_id,
                'link' => $request->link,
                'type' => $request->type,
                'languages' => $request->languages,
                'employee_id' => $request->employee_id,
                'cover_img' => $coverImgPath, // Use the uploaded or existing image
                'img' => $imgPath, // Use the uploaded or existing image
            ]
        );

        // Retrieve all projects and return the view
        $projects = Project::all();
        return view('projects.list', compact('projects'));
    }





    public function edit($id)
    {
        // Retrieve the project along with its related category and employee
        $project = Project::with(['category', 'employee'])->findOrFail($id);

        // Retrieve all categories and employees for the dropdowns
        $categories = Category::all();
        $employees = Employee::all();

        return view('projects.edit', compact('project', 'categories', 'employees'));
    }

    public function destroy($id)
    {
        $Employee = Project::findOrFail($id); // Find Employee or fail
        $Employee->delete();

        // Return the updated list of categories as a JSON response
        $projects = Project::all();

        return view('projects.list', compact('projects'));
    }
}
