<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('employees', function (Blueprint $table) {
            $table->id();
            $table->string('avatar_url');
            $table->string('name');
            $table->text('description'); // Renamed to 'description' to match your 'des' field
            $table->string('designation');
            $table->date('joining_date');
            $table->json('skills'); // Store skills as JSON
            $table->string('official_email')->unique();
            $table->string('company');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('employees');
    }
};
