<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('projects', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->unsignedBigInteger('category_id'); // Use unsignedBigInteger for foreign key references
            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
            $table->text('link')->nullable();
            $table->string('type');
            $table->text('cover_img')->nullable(); // Use underscore instead of hyphen
            $table->text('img')->nullable();
            $table->text('languages');
            $table->unsignedBigInteger('employee_id'); // Foreign key for employees table
            $table->foreign('employee_id')->references('id')->on('employees')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('projects');
    }
};
