<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ApiController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
Route::middleware('check.static.token')->group(function () {
Route::get('/employee-list', [ApiController::class, 'employee'])->name('employees-list');
Route::get('/project-list', [ApiController::class, 'project'])->name('projects-list');
Route::get('/employee/details', [ApiController::class, 'getEmployeeDetails'])->name('employees-details');
});

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

