<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\ProjectController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
// category
Route::get('/category', [CategoryController::class, 'index'])->name('category');
Route::get('/create', [CategoryController::class, 'add'])->name('category-add');
Route::post('/category/store', [CategoryController::class, 'store'])->name('category.store');
Route::get('/category/{id}/edit', [CategoryController::class, 'edit'])->name('category.edit');
Route::delete('/category/{id}', [CategoryController::class, 'destroy'])->name('category.destroy');
// category

// employee
Route::get('/employee', [EmployeeController::class, 'index'])->name('employee');
Route::get('/create-employee', [EmployeeController::class, 'add'])->name('employee-add');
Route::post('/employee/store', [EmployeeController::class, 'store'])->name('employee.store');
Route::get('/employee/{id}/edit', [EmployeeController::class, 'edit'])->name('employee.edit');
Route::delete('/employee/{id}', [EmployeeController::class, 'destroy'])->name('employee.destroy');
// employee

// employee
Route::get('/project', [ProjectController::class, 'index'])->name('project');
Route::get('/create-project', [ProjectController::class, 'add'])->name('project-add');
Route::post('/project/store', [ProjectController::class, 'store'])->name('project.store');
Route::get('/project/{id}/edit', [ProjectController::class, 'edit'])->name('project.edit');
Route::delete('/project/{id}', [ProjectController::class, 'destroy'])->name('project.destroy');
// employee

Auth::routes();

Route::get('/', [App\Http\Controllers\HomeController::class, 'root']);

Route::get('{any}', [App\Http\Controllers\HomeController::class, 'index']);
//Language Translation

Route::get('index/{locale}', [App\Http\Controllers\HomeController::class, 'lang']);

Route::post('/formsubmit', [App\Http\Controllers\HomeController::class, 'FormSubmit'])->name('FormSubmit');

