
<?php $__env->startSection('title'); ?>
<?php echo app('translator')->get('translation.Category'); ?>


<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<!-- DataTables -->
<link href="<?php echo e(URL::asset('assets/libs/datatables/datatables.min.css')); ?>" rel="stylesheet" type="text/css" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastify-js/1.12.0/toastify.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.css">
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php $__env->startComponent('common-components.breadcrumb'); ?>
<?php $__env->slot('pagetitle'); ?> Project <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Employee <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-body">
                <div>
                    <div>
                        <a href="<?php echo e(route('employee-add')); ?>" class="btn btn-success waves-effect waves-light mb-3">
                            <i class="mdi mdi-plus me-1"></i> Add Employees
                        </a>
                    </div>



                    <div class="table-responsive mb-4">
                        <table class="table table-centered datatable dt-responsive nowrap table-card-list" style="border-collapse: collapse; width: 100%;">
                            <thead>
                                <tr>
                                    <th style="width: 20px;">
                                        <div class="form-check text-center">
                                            <input type="checkbox" class="form-check-input" id="customercheck">
                                            <label class="form-check-label" for="customercheck"></label>
                                        </div>
                                    </th>
                                    <th style="width: 120px;">ID</th>
                                    <th>Name</th>
                                    <th>designation</th>
                                    <th>JoiningDate</th>
                                    <th>Email</th>
                                    <th style="width: 120px;">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <div class="form-check text-center">
                                            <input type="checkbox" class="form-check-input" id="customercheck<?php echo e($employee->id); ?>">
                                            <label class="form-check-label" for="customercheck<?php echo e($employee->id); ?>"></label>
                                        </div>
                                    </td>
                                    <td><a href="javascript: void(0);" class="text-reset fw-bold"><?php echo e($employee->id); ?></a></td>
                                    <td>
                                       
                                        <span><?php echo e($employee->name); ?></span>
                                    </td>
                                    <td><?php echo e($employee->designation); ?></td>
                                    <td><?php echo e($employee->joining_date); ?></td>
                                    <td><?php echo e($employee->official_email); ?></td>
                                    
                                    <td>
                                        <a href="<?php echo e(route('employee.edit',$employee->id)); ?>" class="px-3 text-primary"><i class="uil uil-pen font-size-18"></i></a>
                                        <a href="javascript:void(0);" class="px-3 text-danger delete-customer" data-employee-id="<?php echo e($employee->id); ?>"><i class="uil uil-trash-alt font-size-18"></i></a>
                                  

                                    </td>

                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- end row -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="<?php echo e(URL::asset('/assets/libs/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('/assets/js/pages/ecommerce-datatables.init.js')); ?>"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastify-js/1.12.0/toastify.min.js"></script>
<script>
        $(document).ready(function() {
            // Attach a click event handler to the delete button
            $('.delete-customer').click(function() {
                console.log('222');
                // Store a reference to the current button
                var button = $(this);
                var EmployeeId = button.data('employee-id');

                // Display SweetAlert confirmation dialog
                swal({
                    title: "Are you sure?",
                    text: "Once deleted, you will not be able to recover this Employee!",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        // Fetch the CSRF token
                        var csrfToken = $('meta[name="csrf-token"]').attr('content');

                        // Make the AJAX request
                        $.ajax({
                            url: '/employee/' + EmployeeId, // URL to your Laravel route
                            method: 'DELETE', // Correct HTTP method for deletion
                            data: {
                                _token: csrfToken // Include CSRF token for Laravel
                            },
                            success: function(response) {
                                Toastify({
                                    text: "Employee deleted successfully!",
                                    duration: 3000, // Duration in milliseconds
                                    close: true, // Show close button
                                    gravity: "top", // Position (top or bottom)
                                    position: "right", // Position (left, center, right)
                                    backgroundColor: "green" // Custom background color
                                }).showToast();
                                setTimeout(function() {
                                    window.location.reload();
                                }, 1000);

                            },
                            error: function(xhr, status, error) {
                                console.error('Error deleting category:', error);
                                Swal.fire(
                                    'Error!',
                                    'Failed to delete category.',
                                    'error'
                                );
                            }
                        });
                    } else {
                        // If user cancels deletion, do nothing
                        swal("Category deletion cancelled!");
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/icloudcsin/public_html/Project-showcase/resources/views/employees/list.blade.php ENDPATH**/ ?>