<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Category;
use Illuminate\Validation\Rule;

class CategoryController extends Controller
{
    //
    public function index()
    {
        $categories = Category::all();
        return view('ecommerce-customers', compact('categories'));
    }
    public function add()
    {
        return view('ecommerce-add-product');
    }

    public function store(Request $request)
    {
       
        // Validate the request data
        $validatedData = $request->validate([
            'name' => [
                'required',
                'string',
                'max:255',
                Rule::unique('categories')->ignore($request->id), // Ignore if updating existing record
            ],
            'description' => 'nullable|string|max:500', // Add validation for description if necessary
        ]);

        // Use updateOrCreate to either update the existing category or create a new one
        Category::updateOrCreate(
            ['id' => $request->id], // Condition to find the record by ID
            [
                'name' => $request->name, // Data to update or create
                'description' => $request->description,
            ]
        );

        // Return a success message
        return response()->json(['message' => 'Category saved successfully!']);
    }
    public function edit($id)
    {
        $category = Category::findOrFail($id); 

        return view('edit', compact('category')); 
    }
    public function destroy($id)
    {
        $category = Category::findOrFail($id); // Find category or fail
        $category->delete();

        // Return the updated list of categories as a JSON response
        $categories = Category::all();
        
        return view('ecommerce-customers', compact('categories'));
    }
}
