<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Employee;
use Illuminate\Validation\Rule;

class EmployeeController extends Controller
{
    //
    public function index()
    {
        $employees = Employee::all();
        return view('employees.list', compact('employees'));
    }
    public function add()
    {
        return view('employees.add');
    }

    public function store(Request $request)
    {
        // Validate the input
        $request->validate([
         
            'name' => 'required|string|max:255',
            'description' => 'required|string',
            'designation' => 'required|string',
            'joining_date' => 'required|date',
            'skills' => 'required|string', // Since it's a textarea, treat it as string first
            'official_email' => 'required|email|unique:employees,official_email,' . $request->id,
            'company' => 'required|string',
        ]);


        // Save the employee
        Employee::updateOrCreate(
            ['id' => $request->id],
            [
                'avatar_url' => 'null', // Store the file path
                'name' => $request->name,
                'description' => $request->description,
                'designation' => $request->designation,
                'joining_date' => $request->joining_date,
                'skills' => json_encode($request->skills), // Store the skills as JSON
                'official_email' => $request->official_email,
                'company' => $request->company,
            ]
        );

        return response()->json(['success' => 'Employee saved successfully.']);
    }

    public function edit($id)
    {
        $employee = Employee::findOrFail($id);

        return view('employees.edit', compact('employee'));
    }
    public function destroy($id)
    {
        $Employee = Employee::findOrFail($id); // Find Employee or fail
        $Employee->delete();

        // Return the updated list of categories as a JSON response
        $categories = Employee::all();

        return view('ecommerce-customers', compact('categories'));
    }
}
