<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Employee extends Model
{
    use HasFactory;
    protected $table = 'employees';
    protected $fillable = [
        'name',
        'avatar_url',
        'description',
        'designation',
        'joining_date',
        'skills',
        'official_email',
        'company',
    ];
    public function projects()
    {
        return $this->hasMany(Project::class);
    }
}
