@extends('layouts.master')
@section('title')
@lang('translation.Category')


@endsection
@section('css')
<!-- DataTables -->
<link href="{{ URL::asset('assets/libs/datatables/datatables.min.css') }}" rel="stylesheet" type="text/css" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastify-js/1.12.0/toastify.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.css">
<meta name="csrf-token" content="{{ csrf_token() }}">
@endsection

@section('content')
@component('common-components.breadcrumb')
@slot('pagetitle') Project @endslot
@slot('title') Category @endslot
@endcomponent

<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-body">
                <div>
                    <div>
                        <a href="{{ route('category-add') }}" class="btn btn-success waves-effect waves-light mb-3">
                            <i class="mdi mdi-plus me-1"></i> Add category
                        </a>
                    </div>



                    <div class="table-responsive mb-4">
                        <table class="table table-centered datatable dt-responsive nowrap table-card-list" style="border-collapse: collapse; width: 100%;">
                            <thead>
                                <tr>
                                    <th style="width: 20px;">
                                        <div class="form-check text-center">
                                            <input type="checkbox" class="form-check-input" id="customercheck">
                                            <label class="form-check-label" for="customercheck"></label>
                                        </div>
                                    </th>
                                    <th style="width: 120px;">ID</th>
                                    <th>Category</th>
                                    <th>Description</th>
                                    <th>Created at</th>
                                    <th>Updated at</th>
                                    <th style="width: 120px;">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($categories as $category)
                                <tr>
                                    <td>
                                        <div class="form-check text-center">
                                            <input type="checkbox" class="form-check-input" id="customercheck{{ $category->id }}">
                                            <label class="form-check-label" for="customercheck{{ $category->id }}"></label>
                                        </div>
                                    </td>
                                    <td><a href="javascript: void(0);" class="text-reset fw-bold">{{ $category->id }}</a></td>
                                    <td>
                                       
                                        <span>{{ $category->name }}</span>
                                    </td>
                                    <td>{{ $category->description }}</td>
                                    <td>{{ $category->created_at }}</td>
                                    <td>
                                        <div class="badge bg-pill {{ $category->status == 'Active' ? 'bg-success-subtle text-success' : 'bg-warning-subtle text-warning' }} font-size-12">{{ $category->status }}</div>
                                    </td>
                                    <td>
                                        <a href="{{route('category.edit',$category->id)}}" class="px-3 text-primary"><i class="uil uil-pen font-size-18"></i></a>
                                        <a href="javascript:void(0);" class="px-3 text-danger delete-customer" data-category-id="{{ $category->id }}"><i class="uil uil-trash-alt font-size-18"></i></a>
                                  

                                    </td>

                                </tr>
                                @endforeach
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- end row -->

@endsection
@section('script')
<script src="{{ URL::asset('/assets/libs/datatables/datatables.min.js') }}"></script>
<script src="{{ URL::asset('/assets/js/pages/ecommerce-datatables.init.js') }}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastify-js/1.12.0/toastify.min.js"></script>
<script>
        $(document).ready(function() {
            // Attach a click event handler to the delete button
            $('.delete-customer').click(function() {
                console.log('222');
                // Store a reference to the current button
                var button = $(this);
                var categoryId = button.data('category-id');

                // Display SweetAlert confirmation dialog
                swal({
                    title: "Are you sure?",
                    text: "Once deleted, you will not be able to recover this category!",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        // Fetch the CSRF token
                        var csrfToken = $('meta[name="csrf-token"]').attr('content');

                        // Make the AJAX request
                        $.ajax({
                            url: '/category/' + categoryId, // URL to your Laravel route
                            method: 'DELETE', // Correct HTTP method for deletion
                            data: {
                                _token: csrfToken // Include CSRF token for Laravel
                            },
                            success: function(response) {
                                Toastify({
                                    text: "Category deleted successfully!",
                                    duration: 3000, // Duration in milliseconds
                                    close: true, // Show close button
                                    gravity: "top", // Position (top or bottom)
                                    position: "right", // Position (left, center, right)
                                    backgroundColor: "linear-gradient(to right, #00b09b, #96c93d)" // Custom background color
                                }).showToast();
                                setTimeout(function() {
                                    window.location.reload();
                                }, 1000);

                            },
                            error: function(xhr, status, error) {
                                console.error('Error deleting category:', error);
                                Swal.fire(
                                    'Error!',
                                    'Failed to delete category.',
                                    'error'
                                );
                            }
                        });
                    } else {
                        // If user cancels deletion, do nothing
                        swal("Category deletion cancelled!");
                    }
                });
            });
        });
    </script>
@endsection