@extends('layouts.master')
@section('title')
@lang('translation.Add Category')
@endsection
@section('css')
<!-- DataTables -->
<link href="{{ URL::asset('/assets/libs/select2/select2.min.css') }}" rel="stylesheet" type="text/css" />
<link href="{{ URL::asset('/assets/libs/dropzone/dropzone.min.css') }}" rel="stylesheet" type="text/css" />
@endsection

@section('content')
@component('common-components.breadcrumb')
@slot('pagetitle') Project @endslot
@slot('title') Add Employee @endslot
@endcomponent

<div class="row">
    <div class="col-lg-12">
        <div id="addproduct-accordion" class="custom-accordion">
            <div class="card">
                <a href="#addproduct-billinginfo-collapse" class="text-dark" data-bs-toggle="collapse" aria-expanded="true" aria-controls="addproduct-billinginfo-collapse">
                    <div class="p-4">

                        <div class="d-flex align-items-center">
                            <div class="flex-shrink-0 me-3">
                                <div class="avatar-xs">
                                    <!-- <div class="avatar-title rounded-circle bg-primary-subtle text-primary">
                                        01
                                    </div> -->
                                </div>
                            </div>
                            <div class="flex-grow-1 overflow-hidden">
                                <h5 class="font-size-16 mb-1">Employee Info</h5>
                                <p class="text-muted text-truncate mb-0">Fill all information below</p>
                            </div>
                            <div class="flex-shrink-0">
                                <i class="mdi mdi-chevron-up accor-down-icon font-size-24"></i>
                            </div>

                        </div>

                    </div>
                </a>

                <div id="addproduct-billinginfo-collapse" class="collapse show" data-bs-parent="#addproduct-accordion">
                    <div class="p-4 border-top">
                        <form id="projectForm" action="{{ route('project.store') }}" method="POST" enctype="multipart/form-data" >
                            @csrf
                            @if(isset($project))
                            <input type="hidden" name="id" value="{{ $project->id }}">
                            @endif

                            <div class="mb-3">
                                <label class="form-label" for="name">Project Name</label>
                                <input id="name" name="name" type="text" class="form-control @error('name') is-invalid @enderror" value="{{ old('name', $project->name ?? '') }}" placeholder="Enter Project Name">
                                <div class="invalid-feedback"></div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label" for="category_id">Category</label>
                                <select id="category_id" name="category_id" class="form-control @error('category_id') is-invalid @enderror">
                                    @foreach($categories as $category)
                                    <option value="{{ $category->id }}" {{ old('category_id', $project->category_id ?? '') == $category->id ? 'selected' : '' }}>
                                        {{ $category->name }}
                                    </option>
                                    @endforeach
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label" for="link">Link</label>
                                <input id="link" name="link" type="text" class="form-control @error('link') is-invalid @enderror" value="{{ old('link', $project->link ?? '') }}" placeholder="Enter Link">
                                <div class="invalid-feedback"></div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label" for="type">Type</label>
                                <input id="type" name="type" type="text" class="form-control @error('type') is-invalid @enderror" value="{{ old('type', $project->type ?? '') }}" placeholder="Enter Type">
                                <div class="invalid-feedback"></div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label" for="cover_img">Cover Image</label>
                                <input id="cover_img" name="cover_img" type="file" class="form-control @error('cover_img') is-invalid @enderror">
                                <div class="invalid-feedback"></div>
                                @if(isset($project) && $project->cover_img)
                                <img src="{{ Storage::url($project->cover_img) }}" alt="Cover Image" style="max-width: 200px; margin-top: 10px;">
                                @endif
                            </div>

                            <div class="mb-3">
                                <label class="form-label" for="img">Image</label>
                                <input id="img" name="img" type="file" class="form-control @error('img') is-invalid @enderror">
                                <div class="invalid-feedback"></div>
                                @if(isset($project) && $project->img)
                           
                                
                                <img src="{{ Storage::url($project->img) }}" alt="Image" style="max-width: 200px; margin-top: 10px;">
                                @endif
                            </div>

                            <div class="mb-3">
                                <label class="form-label" for="languages">Languages</label>
                                <textarea id="languages" name="languages" class="form-control @error('languages') is-invalid @enderror" rows="4" placeholder="Enter Languages">{{ old('languages', $project->languages ?? '') }}</textarea>
                                <div class="invalid-feedback"></div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label" for="employee_id">Assigned Employee</label>
                                <select id="employee_id" name="employee_id" class="form-control @error('employee_id') is-invalid @enderror">
                                    @foreach($employees as $employee)
                                    <option value="{{ $employee->id }}" {{ old('employee_id', $project->employee_id ?? '') == $employee->id ? 'selected' : '' }}>
                                        {{ $employee->name }} ({{ $employee->designation }})
                                    </option>
                                    @endforeach
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>

                            <div class="row mb-4">
                                <div class="col text-end">
                                    <a href="#" class="btn btn-danger"><i class="uil uil-times me-1"></i> Cancel</a>
                                    <button type="submit" class="btn btn-success">Save Changes <i class="uil uil-file-alt me-1"></i></button>
                                </div>
                            </div>
                        </form>



                    </div>
                </div>
            </div>


        </div>
    </div>
</div>



@endsection
@section('script')

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
        $('#employeeForm').on('submit', function(e) {
            e.preventDefault(); // Prevent the default form submission

            $.ajax({
                type: 'POST',
                url: "{{ route('employee.store') }}",
                data: $(this).serialize(), // Serialize the form data
                success: function(response) {

                    window.location.href = "/employee"; // Redirect to the employee list page or any other page
                },
                error: function(xhr) {
                    // Handle errors
                    if (xhr.status === 422) {
                        // Show validation errors
                        var errors = xhr.responseJSON.errors;
                        console.log(errors); // Log errors for debugging purposes

                        // Clear any previous error messages
                        $('.invalid-feedback').hide();
                        $('.form-control').removeClass('is-invalid');

                        // Loop through each error and display it next to the respective field
                        $.each(errors, function(field, messages) {
                            // Ensure field exists and has a corresponding invalid-feedback element
                            if (messages.length > 0) {
                                // Mark the field as invalid
                                $('#' + field).addClass('is-invalid');

                                // Show the first error message
                                $('#' + field).next('.invalid-feedback').html(messages[0]).show();
                            }
                        });
                    } else {
                        alert('An error occurred. Please try again.');
                    }
                }
            });
        });
    });
</script>
<script>
    document.getElementById('avatar_url').addEventListener('change', function(event) {
        const file = event.target.files[0];
        const avatarPreview = document.getElementById('avatar_preview');

        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                avatarPreview.src = e.target.result;
                avatarPreview.style.display = 'block'; // Show the preview
            };
            reader.readAsDataURL(file); // Read file as Data URL for preview
        } else {
            avatarPreview.style.display = 'none'; // Hide preview if no file is selected
        }
    });
</script>


<script src="{{ URL::asset('/assets/libs/select2/select2.min.js') }}"></script>
<script src="{{ URL::asset('/assets/libs/dropzone/dropzone.min.js') }}"></script>
<script src="{{ URL::asset('/assets/js/pages/ecommerce-add-product.init.js') }}"></script>
@endsection