<?php

function convertNumber($number)
{
    list($integer, $fraction) = explode(".", (string) $number);

    $output = "";

    if ($integer{0} == "-")
    {
        $output = "negative ";
        $integer    = ltrim($integer, "-");
    }
    else if ($integer{0} == "+")
    {
        $output = "positive ";
        $integer    = ltrim($integer, "+");
    }

    if ($integer{0} == "0")
    {
        $output .= "zero";
    }
    else
    {
        $integer = str_pad($integer, 36, "0", STR_PAD_LEFT);
        $group   = rtrim(chunk_split($integer, 3, " "), " ");
        $groups  = explode(" ", $group);

        $groups2 = array();
        foreach ($groups as $g)
        {
            $groups2[] = convertThreeDigit($g{0}, $g{1}, $g{2});
        }

        for ($z = 0; $z < count($groups2); $z++)
        {
            if ($groups2[$z] != "")
            {
                $output .= $groups2[$z] . convertGroup(11 - $z) . (
                        $z < 11
                        && !array_search('', array_slice($groups2, $z + 1, -1))
                        && $groups2[11] != ''
                        && $groups[11]{0} == '0'
                            ? " and "
                            : ", "
                    );
            }
        }

        $output = rtrim($output, ", ");
    }

    if ($fraction > 0)
    {
        $output .= " point";
        for ($i = 0; $i < strlen($fraction); $i++)
        {
            $output .= " " . convertDigit($fraction{$i});
        }
    }

    return $output;
}

function convertGroup($index)
{
    switch ($index)
    {
        case 11:
            return " decillion";
        case 10:
            return " nonillion";
        case 9:
            return " octillion";
        case 8:
            return " septillion";
        case 7:
            return " sextillion";
        case 6:
            return " quintrillion";
        case 5:
            return " QUADRILLION";
        case 4:
            return " TRILLION";
        case 3:
            return " BILLION";
        case 2:
            return " MILLION";
        case 1:
            return " THOUSAND";
        case 0:
            return "";
    }
}

function convertThreeDigit($digit1, $digit2, $digit3)
{
    $buffer = "";

    if ($digit1 == "0" && $digit2 == "0" && $digit3 == "0")
    {
        return "";
    }

    if ($digit1 != "0")
    {
        $buffer .= convertDigit($digit1) . " HUNDRED";
        if ($digit2 != "0" || $digit3 != "0")
        {
            $buffer .= " AND ";
        }
    }

    if ($digit2 != "0")
    {
        $buffer .= convertTwoDigit($digit2, $digit3);
    }
    else if ($digit3 != "0")
    {
        $buffer .= convertDigit($digit3);
    }

    return $buffer;
}

function convertTwoDigit($digit1, $digit2)
{
    if ($digit2 == "0")
    {
        switch ($digit1)
        {
            case "1":
                return "TEN";
            case "2":
                return "TWENTY";
            case "3":
                return "THIRTY";
            case "4":
                return "FORTY";
            case "5":
                return "FIFTY";
            case "6":
                return "SIXTY";
            case "7":
                return "SEVENTY";
            case "8":
                return "EIGHTY";
            case "9":
                return "NINETY";
        }
    } else if ($digit1 == "1")
    {
        switch ($digit2)
        {
            case "1":
                return "ELEVEN";
            case "2":
                return "TWELVE";
            case "3":
                return "THIRTEEN";
            case "4":
                return "FOURTEEN";
            case "5":
                return "FIFTEEN";
            case "6":
                return "SIXTEEN";
            case "7":
                return "SEVENTEEN";
            case "8":
                return "EIGHTEEN";
            case "9":
                return "NINETEEN";
        }
    } else
    {
        $temp = convertDigit($digit2);
        switch ($digit1)
        {
            case "2":
                return "TWENTY $temp";
            case "3":
                return "THIRTY $temp";
            case "4":
                return "FORTY $temp";
            case "5":
                return "FIFTY $temp";
            case "6":
                return "SIXTY $temp";
            case "7":
                return "SEVENTY $temp";
            case "8":
                return "EIGHTY $temp";
            case "9":
                return "NINETY $temp";
        }
    }
}

function convertDigit($digit)
{
    switch ($digit)
    {
        case "0":
            return "ZERO";
        case "1":
            return "ONE";
        case "2":
            return "TWO";
        case "3":
            return "THREE";
        case "4":
            return "FOUR";
        case "5":
            return "FIVE";
        case "6":
            return "SIX";
        case "7":
            return "SEVEN";
        case "8":
            return "EIGHT";
        case "9":
            return "NINE";
    }
}
?>