$(document).ready(function() {
    var itemsPerPage = 6;
    var currentPage = 1;

    function showPage(page) {
        var start = (page - 1) * itemsPerPage;
                var end = start + itemsPerPage;

                // Debug log
                console.log('Showing page:', page, 'Start:', start, 'End:', end);

                $('.agileinfo_new_products_grid').hide().slice(start, end).show();
                updatePagination();
    }

    function updatePagination() {
        var totalItems = $('.agileinfo_new_products_grid').length;
        var totalPages = Math.ceil(totalItems / itemsPerPage);

        // Debug log
        console.log('Total items:', totalItems, 'Total pages:', totalPages);

        $('#pagination').html('<nav aria-label="Page navigation"><ul class="pagination"></ul></nav>');
        var pagination = $('#pagination .pagination');

        for (var i = 1; i <= totalPages; i++) {
            var activeClass = (i === currentPage) ? ' active' : '';
            pagination.append('<li class="page-item' + activeClass + '"><a href="#" class="page-link" data-page="' + i + '">' + i + '</a></li>');
        }
    }
    function filterCategory(category, subcategory) {
        var category="equipment";
        $('.agileinfo_new_products_grid').hide();
        if (category && subcategory) {
            $('.agileinfo_new_products_grid[data-category="' + category + '"][data-subcategory="' + subcategory + '"]').show();
        } else if (category) {
            $('.agileinfo_new_products_grid[data-category="' + category + '"]').show();
        } else {
            $('.agileinfo_new_products_grid').show();
        }

        console.log('Filtered category:', category, 'Filtered subcategory:', subcategory);

        currentPage = 1; // Reset to first page
        updatePagination();
        showPage(currentPage);
    }

    // Click event for category
    $('.panel-title a').click(function() {
        var category = $(this).attr('href').replace('#collapse', '').toLowerCase();
        filterCategory(category);
    });

    // Click event for subcategory
    $('.subcategory').click(function(e) {
        e.preventDefault();
        var category = $(this).closest('.panel-collapse').attr('id').replace('collapse', '').toLowerCase();
        var subcategory = $(this).data('subcategory');
        filterCategory(category, subcategory);
    });

    // Click event for pagination
    $('#pagination').on('click', '.page-link', function(e) {
        e.preventDefault();
        currentPage = $(this).data('page');
        showPage(currentPage);
    });

    // Initial display
    filterCategory('equipment'); // Default category to show on page load
});