/*
Template Name: ASPSTUDIO - Responsive Bootstrap 5 Admin Template
Version: 2.0.0
Author: Sean Ngu
Website: http://www.seantheme.com/asp-studio/
	----------------------------
		APPS CONTENT TABLE
	----------------------------

	<!-- ======== GLOBAL SCRIPT SETTING ======== -->
	01. Global Variable
	02. Handle Scrollbar
	03. Handle Header Search Bar
	04. Handle Sidebar Menu
	05. Handle Sidebar Minify
	06. Handle Sidebar Minify Float Menu
	07. Handle Dropdown Close Option
	08. Handle Panel - Remove / Reload / Collapse / Expand
	09. Handle Tooltip & Popover Activation
	10. Handle Scroll to Top Button Activation
	11. Handle hexToRgba
	12. Handle Scroll to
	
	<!-- ======== APPLICATION SETTING ======== -->
	Application Controller
*/



/* 01. Global Variable
------------------------------------------------ */
var FONT_FAMILY    = '-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,"Noto Sans",sans-serif,"Apple Color Emoji","Segoe UI Emoji","Segoe UI Symbol","Noto Color Emoji"';
var COLOR_BLUE     = '#1f6bff';
var COLOR_GREEN    = '#1abd36';
var COLOR_ORANGE   = '#ff9500';
var COLOR_RED      = '#ff3b30';
var COLOR_AQUA     = '#30beff';
var COLOR_PURPLE   = '#5b2e91';
var COLOR_YELLOW   = '#ffcc00';
var COLOR_INDIGO   = '#640df3';
var COLOR_PINK     = '#ff2d55';
var COLOR_TEAL     = '#0cd096';
var COLOR_BLACK    = '#000000';
var COLOR_WHITE    = '#FFFFFF';
var COLOR_GRAY_100 = '#ebeef4';
var COLOR_GRAY_200 = '#dae0ec';
var COLOR_GRAY_300 = '#c9d2e3';
var COLOR_GRAY_400 = '#a8b6d1';
var COLOR_GRAY_500 = '#869ac0';
var COLOR_GRAY_600 = '#657eae';
var COLOR_GRAY_700 = '#4d6593';
var COLOR_GRAY_800 = '#3c4e71';
var COLOR_GRAY_900 = '#212837';


/* 02. Handle Scrollbar
------------------------------------------------ */
var handleSlimScroll = function() {
	"use strict";
	$.when($('[data-scrollbar=true]').each( function() {
		generateSlimScroll($(this));
	})).done(function() {
		$('[data-scrollbar="true"]').mouseover();
	});
};
var generateSlimScroll = function(element) {
	var isMobile = (/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent));
	
	if ($(element).attr('data-init') || (isMobile && $(element).attr('data-skip-mobile'))) {
		return;
	}
	var dataHeight = $(element).attr('data-height');
		dataHeight = (!dataHeight) ? $(element).height() : dataHeight;

	var scrollBarOption = {
		height: dataHeight, 
		alwaysVisible: false
	};
	if(isMobile) {
		$(element).css('height', dataHeight);
		$(element).css('overflow-x','scroll');
	} else {
		$(element).slimScroll(scrollBarOption);
		$(element).closest('.slimScrollDiv').find('.slimScrollBar').hide();
	}
	$(element).attr('data-init', true);
};


/* 04. Handle Sidebar Menu
------------------------------------------------ */
var handleSidebarMenu = function() {
	"use strict";
	$(document).on('click', '.app-sidebar .menu > .menu-item.has-sub > .menu-link', function(e) {
		e.preventDefault();
		
		var target = $(this).next('.menu-submenu');
		var otherMenu = $('.app-sidebar .menu > .menu-item.has-sub > .menu-submenu').not(target);

		if ($('.app-sidebar-minified').length === 0) {
			$(otherMenu).slideUp(250);
			$(otherMenu).closest('.menu-item').removeClass('expand');
			
			$(target).slideToggle(250);
			var targetElm = $(target).closest('.menu-item');
			if ($(targetElm).hasClass('expand')) {
				$(targetElm).removeClass('expand');
			} else {
				$(targetElm).addClass('expand');
			}
		}
	});
	$(document).on('click', '.app-sidebar .menu > .menu-item.has-sub .menu-submenu .menu-item.has-sub > .menu-link', function(e) {
		e.preventDefault();
		
		if ($('.app-sidebar-minified').length === 0) {
			var target = $(this).next('.menu-submenu');
			$(target).slideToggle(250);
		}
	});
};


/* 05. Handle Sidebar Minify
------------------------------------------------ */
var MOBILE_SIDEBAR_TOGGLE_CLASS = 'app-sidebar-mobile-toggled';
var MOBILE_SIDEBAR_CLOSED_CLASS = 'app-sidebar-mobile-closed';
var handleSidebarMinify = function() {
	$('[data-toggle="sidebar-minify"]').on('click', function(e) {
		e.preventDefault();
		
		var targetElm = '#app';
		var targetClass = 'app-sidebar-minified';
		
		if ($(targetElm).hasClass(targetClass)) {
			$(targetElm).removeClass(targetClass);
			localStorage.removeItem('appSidebarMinified');
		} else {
			$(targetElm).addClass(targetClass);
			localStorage.setItem('appSidebarMinified', true);
		}
	});
	
	if (typeof(Storage) !== 'undefined') {
		if (localStorage.appSidebarMinified) {
			$('#app').addClass('app-sidebar-minified');
		}
	}
};
var handleSidebarMobileToggle = function() {
	$(document).on('click', '[data-toggle="sidebar-mobile"]', function(e) {
		e.preventDefault();
		
		var targetElm = '#app';
		
		$(targetElm).removeClass(MOBILE_SIDEBAR_CLOSED_CLASS).addClass(MOBILE_SIDEBAR_TOGGLE_CLASS);
	});
};
var handleSidebarMobileDismiss = function() {
	$(document).on('click', '[data-dismiss="sidebar-mobile"]', function(e) {
		e.preventDefault();
		
		var targetElm = '#app';
		
		$(targetElm).removeClass(MOBILE_SIDEBAR_TOGGLE_CLASS).addClass(MOBILE_SIDEBAR_CLOSED_CLASS);
		setTimeout(function() {
			$(targetElm).removeClass(MOBILE_SIDEBAR_CLOSED_CLASS);
		}, 250);
	});
};


/* 06. Handle Sidebar Minify Float Menu
------------------------------------------------ */
var floatSubMenuTimeout;
var targetFloatMenu;
var handleMouseoverFloatSubMenu = function(elm) {
	clearTimeout(floatSubMenuTimeout);
};
var handleMouseoutFloatSubMenu = function(elm) {
	floatSubMenuTimeout = setTimeout(function() {
		$('.app-float-submenu').remove();
	}, 250);
};
var handleSidebarMinifyFloatMenu = function() {
	$(document).on('click', '.app-float-submenu .menu-item.has-sub > .menu-link', function(e) {
		e.preventDefault();
		
		var target = $(this).next('.menu-submenu');
		$(target).slideToggle(250, function() {
			var targetMenu = $('.app-float-submenu');
			var targetHeight = $(targetMenu).height() + 20;
			var targetOffset = $(targetMenu).offset();
			var targetTop = $(targetMenu).attr('data-offset-top');
			var windowHeight = $(window).height();
			if ((windowHeight - targetTop) > targetHeight) {
				$('.app-float-submenu').css({
					'top': targetTop,
					'bottom': 'auto',
					'overflow': 'initial'
				});
			} else {
				$('.app-float-submenu').css({
					'bottom': 0,
					'overflow': 'scroll'
				});
			}
		});
	});
	$(document).on('mouseover', '.app-sidebar-minified .app-sidebar .menu .menu-item.has-sub > .menu-link', function() {
		clearTimeout(floatSubMenuTimeout);
		
		var targetMenu = $(this).closest('.menu-item').find('.menu-submenu').first();
		if (targetFloatMenu == this) {
			return false;
		} else {
			targetFloatMenu = this;
		}
		var targetMenuHtml = $(targetMenu).html();
		
		if (targetMenuHtml) {
			var targetHeight = $(targetMenu).height() + 20;
			var targetOffset = $(this).offset();
			var targetTop = targetOffset.top - $(window).scrollTop();
			var targetLeft = (!$('#app').hasClass('app-sidebar-right')) ? $('#sidebar').width() + $('#sidebar').offset().left : 'auto';
			var targetRight = (!$('#app').hasClass('app-sidebar-right')) ? 'auto' : $('#sidebar').width();
			var windowHeight = $(window).height();
			var submenuHeight = 0;
			
			if ($('.app-float-submenu').length == 0) {
				targetMenuHtml = '<div class="app-float-submenu" data-offset-top="'+ targetTop +'" onmouseover="handleMouseoverFloatSubMenu(this)" onmouseout="handleMouseoutFloatSubMenu(this)">' + targetMenuHtml + '</div>';
				$('body').append(targetMenuHtml);
			} else {
				$('.app-float-submenu').html(targetMenuHtml);
			}
			submenuHeight = $('.app-float-submenu').height();
			if ((windowHeight - targetTop) > targetHeight && ((targetTop + submenuHeight) < windowHeight)) {
				$('.app-float-submenu').css({
					'top': targetTop,
					'left': targetLeft,
					'bottom': 'auto',
					'right': targetRight
				});
			} else {
				$('.app-float-submenu').css({
					'bottom': 0,
					'top': 'auto',
					'left': targetLeft,
					'right': targetRight
				});
			}
		} else {
			$('.app-float-submenu').remove();
			targetFloatMenu = '';
		}
	});
	$(document).on('mouseout', '.app-sidebar-minified .app-sidebar .menu > .menu-item.has-sub > .menu-link', function() {
		floatSubMenuTimeout = setTimeout(function() {
			$('.app-float-submenu').remove();
			targetFloatMenu = '';
		}, 250);
	});
}


/* 07. Handle Dropdown Close Option
------------------------------------------------ */
var handleDropdownClose = function() {
	$(document).on('click', '[data-dropdown-close="false"]', function(e) {
		e.stopPropagation();
	});
};


/* 08. Handle Card - Remove / Reload / Collapse / Expand
------------------------------------------------ */
var cardActionRunning = false;
var handleCardAction = function() {
	"use strict";

	if (cardActionRunning) {
		return false;
	}
	cardActionRunning = true;

	// expand
	$(document).on('mouseover', '[data-toggle=card-expand]', function(e) {
		if (!$(this).attr('data-init')) {
			$(this).tooltip({
				title: 'Expand / Compress',
				placement: 'bottom',
				trigger: 'hover',
				container: 'body'
			});
			$(this).tooltip('show');
			$(this).attr('data-init', true);
		}
	});
	$(document).on('click', '[data-toggle=card-expand]', function(e) {
		e.preventDefault();
		var target = $(this).closest('.card');
		var targetBody = $(target).find('.card-body');
		var targetClass = 'card-expand';
		var targetTop = 40;
		if ($(targetBody).length !== 0) {
			var targetOffsetTop = $(target).offset().top;
			var targetBodyOffsetTop = $(targetBody).offset().top;
			targetTop = targetBodyOffsetTop - targetOffsetTop;
		}

		if ($('body').hasClass(targetClass) && $(target).hasClass(targetClass)) {
			$('body, .card').removeClass(targetClass);
			$('.card').removeAttr('style');
			$(targetBody).removeAttr('style');
		} else {
			$('body').addClass(targetClass);
			$(this).closest('.card').addClass(targetClass);
		}
		$(window).trigger('resize');
	});
};


/* 09. Handle Tooltip & Popover Activation
------------------------------------------------ */
var handelTooltipPopoverActivation = function() {
	"use strict";
	if ($('[data-toggle="tooltip"]').length !== 0) {
		$('[data-toggle=tooltip]').tooltip();
	}
	if ($('[data-toggle="popover"]').length !== 0) {
		$('[data-toggle=popover]').popover();
	}
};


/* 10. Handle Scroll to Top Button Activation
------------------------------------------------ */
var handleScrollToTopButton = function() {
	"use strict";
	$(document).on('scroll', function() {
		var totalScroll = $(document).scrollTop();

		if (totalScroll >= 200) {
			$('[data-click=scroll-top]').addClass('show');
		} else {
			$('[data-click=scroll-top]').removeClass('show');
		}
	});
	$('[data-click=scroll-top]').on('click', function(e) {
		e.preventDefault();
		$('html, body, .content').animate({
			scrollTop: $("body").offset().top
		}, 500);
	});
};


/* 11. Handle hexToRgba
------------------------------------------------ */
var hexToRgba = function(hex, transparent = 1) {
	var c;
	if(/^#([A-Fa-f0-9]{3}){1,2}$/.test(hex)){
			c= hex.substring(1).split('');
			if(c.length== 3){
					c= [c[0], c[0], c[1], c[1], c[2], c[2]];
			}
			c= '0x'+c.join('');
			return 'rgba('+[(c>>16)&255, (c>>8)&255, c&255].join(',')+','+ transparent +')';
	}
  throw new Error('Bad Hex');
};


/* 12. Handle Scroll to
------------------------------------------------ */
var handleScrollTo = function() {
	$(document).on('click', '[data-toggle="scroll-to"]', function(e) {
		e.preventDefault();
		
		var targetElm = ($(this).attr('data-target')) ? $(this).attr('data-target') : $(this).attr('href');
		if (targetElm) {
			$('html, body').animate({
				scrollTop: $(targetElm).offset().top - $('#header').height() - 24
			}, 0);
		}
	});
};


/* Application Controller
------------------------------------------------ */
var App = function () {
	"use strict";
	
	return {
		//main function
		init: function () {
			this.initSidebar();
			this.initHeader();
			this.initComponent();
		},
		initSidebar: function() {
			handleSidebarMinifyFloatMenu();
			handleSidebarMenu();
			handleSidebarMinify();
			handleSidebarMobileToggle();
			handleSidebarMobileDismiss();
		},
		initHeader: function() {
		},
		initComponent: function() {
			handleSlimScroll();
			handleCardAction();
			handelTooltipPopoverActivation();
			handleScrollToTopButton();
			handleDropdownClose();
			handleScrollTo();
		},
		scrollTop: function() {
			$('html, body, .content').animate({
				scrollTop: $('body').offset().top
			}, 0);
		}
	};
}();

$(document).ready(function() {
	App.init();
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
