<?php
ob_start();
session_start();
require_once "dbconnect.php";

date_default_timezone_set("Asia/Kolkata");

/*---------- Execute Mysql Select function ----------*/

function get_entry_status($status_id)
{
    if ($status_id == '0') {
        $status = "Enquiry";
    } else if ($status_id == '1') {
        $status = "Booking Confirmed";
    } else if ($status_id == '2') {
        $status = "Trip Started";
    } else if ($status_id == '3') {
        $status = "Reached Hub";
    } else if ($status_id == '4') {
        $status = "Missing in hub";
    } else if ($status_id == '5') {
        $status = "Shipping to Branch";
    } else if ($status_id == '6') {
        $status = "Reached Branch";
    } else if ($status_id == '7') {
        $status = "Missing from branch";
    } else if ($status_id == '8') {
        $status = "Out Of Delivery";
    } else if ($status_id == '9') {
        $status = "Completed";
    } else if ($status_id == '10') {
        $status = "Cancelled";
    } else if ($status_id == '11') {
        $status = "Return";
    } else if ($status_id == '12') {
        $status = "Return Completed";
    } else if ($status_id == '13') {
        $status = "Partial Completed";
    } else {
        $status = "NA";
    }

    return  $status;
}


function get_unique_id()

{

    $unique = uniqid() . rand(100000, 999999);

    return $unique;
}

function arrow_changes($original, $current)
{
    if ($original != 0 && $current != 0) {
        $diff = $current - $original;
        $more_less = $diff > 0 ? "fa fa-caret-up" : "fa fa-caret-down";
        return  $more_less;
    } else {
        return  "fa fa-caret-up";
    }
}

function percentage_changes($original, $current)
{
    if ($original != 0 && $current != 0) {
        $diff = $current - $original;
        $more_less = $diff > 0 ? "increase" : "decrease";
        $diff = abs($diff);
        $percentChange = ($diff / $original) * 100;

        return  number_format($percentChange, 2) . "% " . $more_less . " </br>compare to last day";
    } else {
        return  " 0% increase </br>compare to last day";
    }
}


function amount_inr_format($amount)

{

    $amount = round($amount, 2);



    $amountArray =  explode('.', $amount);



    if (count($amountArray) == 1) {

        $int = $amountArray[0];

        $des = 00;
    } else {

        $int = $amountArray[0];

        $des = $amountArray[1];
    }

    if (strlen($des) == 1) {

        $des = $des . "0";
    }

    if ($int >= 0) {

        $int = numFormatIndia($int);

        $themoney = $int . "." . $des;
    } else {

        $int = abs($int);

        $int = numFormatIndia($int);

        $themoney = "-" . $int . "." . $des;
    }



    return $themoney;
}





function numFormatIndia($num)

{



    $explrestunits = "";

    if (strlen($num) > 3) {

        $lastthree = substr($num, strlen($num) - 3, strlen($num));

        $restunits = substr($num, 0, strlen($num) - 3);

        $restunits = (strlen($restunits) % 2 == 1) ? "0" . $restunits : $restunits;

        $expunit = str_split($restunits, 2);

        for ($i = 0; $i < sizeof($expunit); $i++) {



            if ($i == 0) {

                $explrestunits .= (int)$expunit[$i] . ",";
            } else {

                $explrestunits .= $expunit[$i] . ",";
            }
        }

        $thecash = $explrestunits . $lastthree;
    } else {

        $thecash = $num;
    }

    return $thecash;
}







function query($sql = "")

{

    global $pdo_conn;



    $result = "";
    $count = 0;
    $response = array();



    $prepare         = $pdo_conn->prepare($sql);



    $selectcustomer  = $prepare->execute();



    $result          = $prepare->fetchAll(PDO::FETCH_ASSOC);



    $count           = count($result);



    $response        = array(



        'sql'      => $sql,

        'data'     => $result,

        'count'    => $count

    );



    return $response;
}








/*---------- Execute Mysql Insert function ----------*/



function save_data($table, $value)

{

    global $pdo_conn;



    $data = "";
    $result = array();
    $last_id = 0;



    $table = $table;



    $fields = implode(',', array_keys($value));

    $values = implode(',', array_values($value));



    $fieldParam = ':' . implode(',:', array_keys($value));



    $binding = array_combine(explode(',', $fieldParam), $value);



    $sql       = "INSERT INTO $table ($fields) VALUES ($fieldParam)";

    $prepare   = $pdo_conn->prepare($sql);

    $executed  = $prepare->execute($binding);

    $last_id   = $pdo_conn->lastInsertId();



    /*----------- Ref sql --------------------*/



    foreach ($value as  $value) {

        $data   .= "'" . $value . "',";
    }

    $data    = rtrim($data, ',');

    $ref_sql = "INSERT INTO $table ($fields) VALUES ($data)";



    /*-----------------------------------------*/



    $result = array(

        'sql'         => $ref_sql,

        'result'     => $executed,

        'last_id'     => $last_id



    );



    return $result;
}





/*------- Execute Mysql Update function ----*/



function update_data($table, array $value, $where = null)

{

    global $pdo_conn;

    $result     = array();

    $fields     = implode(',', array_keys($value));

    $values     = implode(',', array_values($value));



    $fieldParam = ':' . implode(',:', array_keys($value));



    $binding     = array_combine(explode(',', $fieldParam), $value);



    $BindfieldParam = implode(', ', array_map(function ($field, $param) {
        return $field . '=' . $param;
    }, array_keys($value), array_keys($binding)));



 $sql = "UPDATE $table SET $BindfieldParam";



    if (is_array($where) && count($where) != 0) {



        $where = array_map(function ($value, $key) {

            return $key . "='" . $value . "'";
        }, $where, array_keys($where));



        $where     = implode(' AND ', $where);
    }



    if (!empty($where) && $where !== null) {

        $sql     .= " WHERE " . $where;
    }

    $prepare     = $pdo_conn->prepare($sql);

    $executed     = $prepare->execute($binding);



    /*--------- Ref Update Sql ----------*/



    $ref_sql  = "";
    $update_value = "";
    $update = "";

    $ref_sql .= "UPDATE $table SET ";



    foreach ($value as $key => $data) {

        $update_value .= "" . $key . "='" . $data . "',";
    }

    $update .= rtrim($update_value, ',');

    $ref_sql .= $update . 'WHERE ' . $where;



    $result = array(



        'sql'      => $ref_sql,

        'result' =>    $executed



    );



    return $result;
}



/*------------ Get User IP Address ------------- */



function get_ip_address()
{

    $ipaddress = '';

    if ($_SERVER['REMOTE_ADDR'] != '')

        $ipaddress = $_SERVER['REMOTE_ADDR'];

    else if ($_SERVER['REMOTE_HOST'] != '')

        $ipaddress = $_SERVER['REMOTE_HOST'];

    else if (getenv('HTTP_CLIENT_IP'))

        $ipaddress = getenv('HTTP_CLIENT_IP');

    else if (getenv('HTTP_X_FORWARDED_FOR'))

        $ipaddress = getenv('HTTP_X_FORWARDED_FOR');

    else if (getenv('HTTP_X_FORWARDED'))

        $ipaddress = getenv('HTTP_X_FORWARDED');

    else if (getenv('HTTP_FORWARDED_FOR'))

        $ipaddress = getenv('HTTP_FORWARDED_FOR');

    else if (getenv('HTTP_FORWARDED'))

        $ipaddress = getenv('HTTP_FORWARDED');

    else if (getenv('REMOTE_ADDR'))

        $ipaddress = getenv('REMOTE_ADDR');

    else

        $ipaddress = 'UNKNOWN';

    return $ipaddress;
}

/*----------- Total found Columns ----------*/



function found_rows_count()
{

    global $pdo_conn;

    $totalcount = 0;

    $sql = "SELECT FOUND_ROWS() as total";

    $prepare = $pdo_conn->prepare($sql);

    $exc = $prepare->execute();

    if ($exc == TRUE) {

        $list = $prepare->fetchAll();



        $totalcount = $list[0];
    }



    return $totalcount['total'];
}





/*-------- Get Correct Date Formate ---*/



function date_month_year($date_value)

{

    $date_create = date_create($date_value);

    $date = date_format($date_create, 'd-m-Y');

    return $date;
}

function date_month_year_time($date_value)

{

    $date_value=strtotime($date_value);
    $date = date("d-m-Y", $date_value);
    $time = date("h:i:s a", $date_value);

    $date_str = "<div>$date</div><span style='font-size:10px'>$time</span>";

    // $date = date_format($date_create, 'd-m-Y');

    return $date_str;
}



/*------- Files Upload Function ------*/



// $path       =  "../staff_upload_files/";

// $title      =  "Documents";

// $extensions =  array("jpeg","jpg","png");

// $result     =  files_uploading($_FILES['documents'],$path,$title,$extensions);



function files_uploading($base_file, $path, $title, $extensions)

{

    $saved_name = array();

    $date         = date('m-d-Y');

    $count      = count($base_file['name']);



    for ($i = 0; $i < $count; $i++) {



        $random     = rand(0000, 9999);

        $file_name = $base_file['name'][$i];

        $file_size = $base_file['size'][$i];

        $file_tmp  = $base_file['tmp_name'][$i];

        $file_type = $base_file['type'][$i];



        $ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

        $upload_path  = $path . $title . '-' . ($i + 1) . '-' . $date . '-' . $random . '.' . $ext;

        if (in_array($ext, $extensions)) {

            $result   = move_uploaded_file($file_tmp, $upload_path);

            if ($result == true) {

                $saved_name[] = $upload_path;
            }
        }
    }



    return $saved_name;
}



function acc_year_using_date($date = "")

{

    $acc_year  = "";

    $from_year = "";

    $to_year   = "";



    if ($date != "") {

        $explode  = explode('-', $date);

        $year     = $explode[0];

        $month    = $explode[1];

        $day      = $explode[2];

        if ($month > 3) {

            $from_year  = $year;

            $to_year    = $year + 1;
        } else {

            $from_year = $year - 1;

            $to_year   = $year;
        }
    } else {

        $from_year = date('Y');

        $to_year   = $from_year + 1;
    }

    $acc_year = $from_year . '-' . $to_year;



    return $acc_year;
}





function no_to_words($no)

{

    $words = array('0' => '', '1' => 'ONE', '2' => 'TWO', '3' => 'THREE', '4' => 'FOUR', '5' => 'FIVE', '6' => 'SIX', '7' => 'SEVEN', '8' => 'EIGHT', '9' => 'NINE', '10' => 'TEN', '11' => 'ELEVEN', '12' => 'TWELVE', '13' => 'THIRTEEN', '14' => 'FOURTEEN', '15' => 'FIFTEEN', '16' => 'SIXTEEN', '17' => 'SEVENTEEN', '18' => 'EIGHTEEN', '19' => 'NINETEEN', '20' => 'TWENTY', '30' => 'THIRTY', '40' => 'fourty', '50' => 'FIFTY', '60' => 'SIXTY', '70' => 'SEVENTY', '80' => 'EIGHTY', '90' => 'NINTY', '100' => 'HUNDRED AND', '1000' => 'THOUSAND', '100000' => 'LAKH', '10000000' => 'CRORE');

    if ($no == 0)

        return ' ';

    else {

        $novalue = '';

        $highno = $no;

        $remainno = 0;

        $value = 100;

        $value1 = 1000;

        while ($no >= 100) {

            if (($value <= $no) && ($no  < $value1)) {

                $novalue = $words["$value"];

                $highno = (int)($no / $value);

                $remainno = $no % $value;

                break;
            }

            $value = $value1;

            $value1 = $value * 100;
        }

        if (array_key_exists("$highno", $words))

            return $words["$highno"] . " " . $novalue . " " . no_to_words($remainno);

        else {

            $unit = $highno % 10;

            $ten = (int)($highno / 10) * 10;

            return $words["$ten"] . " " . $words["$unit"] . " " . $novalue . " " . no_to_words($remainno);
        }
    }
}







function get_roll_action_permission($page_name, $short_name, $userroll)
{

    $status = '0';

    $sql_page = "SELECT userform_id FROM userform WHERE short_name ='" . $page_name . "' ";

    $data1  = query($sql_page);

    if ($data1['count'] == 1) {

        $list_page = $data1['data'][0];

        $sql = "SELECT userform_id FROM userform WHERE short_name ='" . $short_name . "' AND sub_id ='" . $list_page['userform_id'] . "'";

        $query1  = query($sql);

        if ($query1['count'] == 1) {

            $list_1 = $query1['data'][0];

            $sql_1 = "SELECT status FROM userformrights  WHERE roll_id ='" . $userroll . "' AND form_id ='" . $list_1['userform_id'] . "' ";

            $query2  = query($sql_1);

            if ($query2['count'] == 1) {

                $status = $query2['data'][0]['status'];
            }
        }
    }

    return $status;
}

function get_username($user_id)
{
    global $pdo_conn;

    $totalcount = 0;

    $name =  '';

    $contact = '';

    $branch_code = '';

    $head_name = '';

    $name =  '';

    if ($user_id != "") {

        $sql = "SELECT head_name,branch_code,contact_number FROM `user_creation` where user_id=" . $user_id;

        $prepare = $pdo_conn->prepare($sql);

        $exc = $prepare->execute();

        if ($exc == TRUE) {

            $name  = $prepare->fetch();

            $contact = $name['contact_number'];

            $branch_code = $name['branch_code'];

            $head_name = $name['head_name'];
        }
    }
// . "-" . $head_name . "-" . $contact
    return $branch_code."-" . $head_name;
}



function get_booking_sublist_values($random_sc, $coupon)
{
    global $pdo_conn;

    $sublist       = '';
    $net_total = 0;
    $coupon_amt = 0;
    $gross_amt = 0;

    $sql_1 = "SELECT A.*, B.box_rate, B.beal_rate, B.large_material_rate, B.grand_total FROM tb_booking_sublist A LEFT JOIN tb_booking_main B ON A.random_sc = B.random_sc WHERE A.random_sc='" . $random_sc . "' AND A.delete_status=0 GROUP BY A.id";
    $prepare = $pdo_conn->prepare($sql_1);
    $prepare->execute();
    $list_data = $prepare->fetchall();
    if ($list_data == true) {
        $msg = "Sublist getted succesfully";
        $n   = 1;

        foreach ($list_data as $value) {

            $beal_type   = material_name($value['beal_type']);
            $box_type    = material_name($value['box_type']);
            $large_material_type   = material_name($value['large_material_type']);

            $box_quantity    = $value['box_quantity'];
            $beal_quantity   = $value['beal_quantity'];
            $large_material_quantity   = $value['large_material_quantity'];
            $id        = $value['id'];

            $box_rate  = $box_quantity * $value['box_rate'];
            $beal_rate = $beal_quantity * $value['beal_rate'];
            $lm_rate   = $large_material_quantity * $value['large_material_rate'];
            $sub_rate = $box_rate + $beal_rate + $lm_rate;

            $net_total += $sub_rate;

            if ($box_type == '') {
                $box_type = ' - ';
            }

            if ($beal_type == '') {
                $beal_type = ' - ';
            }

            if ($large_material_type == '') {
                $large_material_type = ' - ';
            }

            $btn = '<a href="javascript:" onclick="sublist_edit(' . $id . ')" title="Edit"><i class="fa fa-edit  fa-lg mr-2" aria-hidden="true"></i></a><a href="javascript:" onclick="sublist_delete(' . $id . ')" title="Delete"><i class="fa fa-trash  fa-lg mr-2" aria-hidden="true"></i></a>';


            $sublist .= '
            <tr>
            <td>' . $n . '</td>
            <td>' . $box_type . '</td>
            <td>' . $box_quantity . '</td>
            <td>' . $beal_type . '</td>
            <td>' . $beal_quantity . '</td>
            <td>' . $large_material_type . '</td>
            <td>' . $large_material_quantity . '</td>
            <td style="text-align: right;" >' . amount_inr_format($sub_rate) . '</td>
            <td>' . $btn . '</td> 
            </tr>';
            $n++;
        }

        $gross_amt = $net_total;

        if ($coupon != '') {
            $sql_coupon = "SELECT id,code,coupon_per,coupon_amt FROM `coupon` where delete_status=0 and id='" . $coupon . "'";
            $prepare = $pdo_conn->prepare($sql_coupon);
            $prepare->execute();
            $coupon_data = $prepare->fetch();

            if ($coupon_data['coupon_per'] != '' && $coupon_data['coupon_per'] != 0 && $coupon_data['coupon_per'] != 0.00) {
                $coupon_amt = $net_total * ($coupon_data['coupon_per'] / 100);
            } else {
                $coupon_amt = $coupon_data['coupon_amt'];
            }
        }

        $net_total = $net_total - $coupon_amt;

        if ($coupon_amt != 0) {
            $sublist .= '
            <tr>
            <td colspan="7" style="text-align: right;"><b>Gross Amount : </b></td>
            <td colspan="1" style="text-align: right;"><b>' . amount_inr_format($gross_amt) . '</b></td><td></td>
            </tr>';
            $sublist .= '
            <tr>
            <td colspan="7" style="text-align: right;"><b>Discound : </b></td>
            <td colspan="1" style="text-align: right;"><b>' . amount_inr_format($coupon_amt) . '</b></td><td></td>
            </tr>';
        }

        $sublist .= '
            <tr>
            <td colspan="7" style="text-align: right;"><b>Net Total : </b><input type="hidden" id="grand_total"  name ="grand_total" class="form-control" value="' . $net_total . '"></td>
            <td colspan="1" style="text-align: right;"><b>' . amount_inr_format($net_total) . '</b></td><td></td>
            </tr>';
    } else {
        $sublist .= '<input type="hidden" id="grand_total"  name ="grand_total" class="form-control" value="0.00">';
    }
    return $sublist;
}





function get_booking_sublist_values_new($random_sc, $coupon)
{
    global $pdo_conn;

    $sublist       = '';
    $net_total = 0;
    $coupon_amt = 0;
    $gross_amt = 0;

    $box_type = $box_quantity = $beal_type = $beal_quantity = $large_material_type = $large_material_quantity = 0;
    $sql_1 = "SELECT A.*, B.box_rate, B.beal_rate, B.large_material_rate, B.grand_total FROM tb_booking_sublist A LEFT JOIN tb_booking_main B ON A.random_sc = B.random_sc WHERE A.random_sc='" . $random_sc . "' AND A.delete_status=0 GROUP BY A.id";
    $prepare = $pdo_conn->prepare($sql_1);
    $prepare->execute();
    $list_data = $prepare->fetchall();
    if ($list_data == true) {
        $msg = "Sublist getted succesfully";
        $n   = 1;

        foreach ($list_data as $value) {

            $material_type   = materialmaster($value['m_type']);

            $id        = $value['id'];

            $rate = $value['rate'];
            $m_quantity = $value['m_quantity'];
            $sub_rate = $rate * $m_quantity;
            $net_total += $sub_rate;


            $btn = '<a href="javascript:" onclick="sublist_edit(' . $id . ')" title="Edit"><i class="fa fa-edit  fa-lg mr-2" aria-hidden="true"></i></a><a href="javascript:" onclick="sublist_delete(' . $id . ')" title="Delete"><i class="fa fa-trash  fa-lg mr-2" aria-hidden="true"></i></a>';


            $sublist .= '
            <tr>
            <td>' . $n . '</td>
            <td>' . $box_type . '</td>
            <td>' . $box_quantity . '</td>
            <td>' . $beal_type . '</td>
            <td>' . $beal_quantity . '</td>
            <td>' . $large_material_type . '</td>
            <td>' . $large_material_quantity . '</td>
            <td style="text-align: right;" >' . amount_inr_format($sub_rate) . '</td>
            <td>' . $btn . '</td> 
            </tr>';
            $n++;
        }

        $gross_amt = $net_total;

        if ($coupon != '') {
            $sql_coupon = "SELECT id,code,coupon_per,coupon_amt FROM `coupon` where delete_status=0 and id='" . $coupon . "'";
            $prepare = $pdo_conn->prepare($sql_coupon);
            $prepare->execute();
            $coupon_data = $prepare->fetch();

            if ($coupon_data['coupon_per'] != '' && $coupon_data['coupon_per'] != 0 && $coupon_data['coupon_per'] != 0.00) {
                $coupon_amt = $net_total * ($coupon_data['coupon_per'] / 100);
            } else {
                $coupon_amt = $coupon_data['coupon_amt'];
            }
        }

        $net_total = $net_total - $coupon_amt;

        if ($coupon_amt != 0) {
            $sublist .= '
            <tr>
            <td colspan="7" style="text-align: right;"><b>Gross Amount : </b></td>
            <td colspan="1" style="text-align: right;"><b>' . amount_inr_format($gross_amt) . '</b></td><td></td>
            </tr>';
            $sublist .= '
            <tr>
            <td colspan="7" style="text-align: right;"><b>Discound : </b></td>
            <td colspan="1" style="text-align: right;"><b>' . amount_inr_format($coupon_amt) . '</b></td><td></td>
            </tr>';
        }

        $sublist .= '
            <tr>
            <td colspan="7" style="text-align: right;"><b>Net Total : </b><input type="hidden" id="grand_total"  name ="grand_total" class="form-control" value="' . $net_total . '"></td>
            <td colspan="1" style="text-align: right;"><b>' . amount_inr_format($net_total) . '</b></td><td></td>
            </tr>';
    } else {
        $sublist .= '<input type="hidden" id="grand_total"  name ="grand_total" class="form-control" value="0.00">';
    }
    return $sublist;
}



function get_pricemaster_sublist($random_sc)
{
    global $pdo_conn;

    $sublist       = '';


    $sql_1 = "SELECT * FROM tb_pricemaster_sublist WHERE random_sc='" . $random_sc . "' AND delete_status=0";
    $prepare = $pdo_conn->prepare($sql_1);
    $prepare->execute();
    $list_data = $prepare->fetchall();

    if ($list_data == true) {
        $n   = 1;
        foreach ($list_data as $value) {

            $rate   = $value['rate'];

            $from_state   = statemaster($value['from_state']);
            $to_state     = statemaster($value['to_state']);

            $from_city   = citymaster($value['from_city']);
            $to_city     = citymaster($value['to_city']);

            $delivery_days   = $value['delivery_days'];

            $material_type   = materialmaster($value['m_type']);


            $id        = $value['id'];
            $e_date        = $value['date'];

            $btn = '<a href="#" onclick="sublist_edit(' . $id . ')" title="Edit"><i class="fa fa-edit fa-lg mr-2" aria-hidden="true"></i></a><a href="#" onclick="sublist_delete(' . $id . ')" title="Delete"><i class="fa fa-trash  fa-lg mr-2" aria-hidden="true"></i></a>';


            $sublist .= '
            <tr>
            <td>' . $n . '</td>
            <td>' . $from_state . '</td>
            <td>' . $from_city . '</td>
            <td>' . $to_state . '</td>
            <td>' . $to_city . '</td>
            <td>' . $material_type . '</td>
            <td>' . amount_inr_format($rate) . '</td>
            <td>' . $delivery_days . '</td>
            <td>' . $btn . '</td> 
            </tr>';
            $n++;
        }
    }
    return $sublist;
}

function statemaster($state_id)
{
    global $pdo_conn;

    $state_name = "";

    $sql = "SELECT state FROM tb_state_master WHERE id='" . $state_id . "' AND delete_status=0";
    $prepare = $pdo_conn->prepare($sql);
    $prepare->execute();
    $list_data = $prepare->fetchcolumn();
    if ($list_data) {
        $state_name = $list_data;
    }

    return $state_name;
}



function citymaster($city_id)
{
    global $pdo_conn;

    $state_name = "";

    $sql = "SELECT district FROM tb_district_master WHERE id='" . $city_id . "' AND delete_status=0";
    $prepare = $pdo_conn->prepare($sql);
    $prepare->execute();
    $list_data = $prepare->fetchcolumn();
    if ($list_data) {
        $state_name = $list_data;
    }

    return $state_name;
}



function materialmaster($id)
{
    global $pdo_conn;

    $state_name = "";

    $sql = "SELECT material_type FROM tb_material_master WHERE id='" . $id . "' AND delete_status=0";
    $prepare = $pdo_conn->prepare($sql);
    $prepare->execute();
    $list_data = $prepare->fetchcolumn();
    if ($list_data) {
        $state_name = $list_data;
    }

    return $state_name;
}




function material_name($material_id)
{
    global $pdo_conn;
    $material_name = " - ";

    if ($material_id != '' && $material_id != 0) {
        $sql = "SELECT GROUP_CONCAT(name) FROM `category` where delete_status=0 and active_status=0 and id IN (" . $material_id . ") ";
        $prepare = $pdo_conn->prepare($sql);
        $prepare->execute();
        $list_data = $prepare->fetchcolumn();

        if ($list_data) {
            $material_name = $list_data;
        }
    }

    return $material_name;
}



function trip_driver_sms1($trip_id)
{
    global $pdo_conn;

    $sql = "SELECT * FROM tb_trip_main WHERE id='" . $trip_id . "'";
    $prepare = $pdo_conn->prepare($sql);
    $prepare->execute();
    $list = $prepare->fetch();
    $from_phone = $list['mobile_number'];
    $lsc_code = $list['lsc_code'];
    $tsc_code = $list['tsc_code'];
    $url = "www.queencargo.in/b.php?id=" . $list['id'];

    $url = "http://app.msgpedia.com/http-tokenkeyapi.php?authentic-key=35377532626f6f6b696e673935361622713413&senderid=UTOBOK&route=2&number=" . $from_phone . "&message=Dear%20Driver,%20Your%20trip%20was%20allotted%20to%20" . $url . ".%20Your%20LSC%20code%20is%20" . $lsc_code . "%20.%20queencargo.in%20-%20U2BOOKING&templateid=1207163877159573169";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, "");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $data1 = curl_exec($ch);
    curl_close($ch);

    return true;
}


function trip_count_detail($vehicle_no, $lsc_code, $tsc_code)
{

    global $pdo_conn;
    $status = '';

    $booking_trip_count = $booking_hub_count = 0;
    $booking_dispatch_trip_count = $booking_dispatch_hub_count = 0;
    $in_trip = $in_hub = 0;

    $trip_sql_main = "SELECT * FROM `tb_trip_main` WHERE type IN ('Trip', 'Hub_Trip') AND vehicle_no = '$vehicle_no' AND lsc_code = '$lsc_code' AND tsc_code = '$tsc_code' AND delete_status = 0 AND trip_status = 0";
    $prepare = $pdo_conn->prepare($trip_sql_main);
    $exc = $prepare->execute();
    $trip_data = $prepare->fetchAll();

    foreach ($trip_data as $data) {
        if ($data['type'] == 'Trip') {
            $status = 2;
        } elseif ($data['type'] == 'Hub_Trip') {
            $status = 4;
        }

        $sql_booking = "SELECT IFNULL(COUNT(*),0) FROM tb_trip_sublist WHERE delete_status = 0 AND trip_id = '" . $data['id'] . "'";
        $prepare = $pdo_conn->prepare($sql_booking);
        $exc = $prepare->execute();
        if ($data['type'] == 'Trip') {
            $booking_trip_count += (int)$prepare->fetchColumn();
        } elseif ($data['type'] == 'Hub_Trip') {
            $booking_hub_count += (int)$prepare->fetchColumn();
        }

        $sql_booking = "SELECT IFNULL(COUNT(*),0) FROM tb_trip_sublist a INNER JOIN tb_booking_main b on a.booking_id=b.id WHERE a.delete_status = 0 and b.delete_status = 0 AND b.status > $status AND a.trip_id = '" . $data['id'] . "' ";
        $prepare = $pdo_conn->prepare($sql_booking);
        $exc = $prepare->execute();

        if ($data['type'] == 'Trip') {
            $booking_dispatch_trip_count += (int)$prepare->fetchColumn();
        } elseif ($data['type'] == 'Hub_Trip') {
            $booking_dispatch_hub_count += (int)$prepare->fetchColumn();
        }
    }
    $in_trip = ($booking_trip_count - $booking_dispatch_trip_count);
    $in_hub = ($booking_hub_count - $booking_dispatch_hub_count);

    $balance_count = $in_hub + $in_trip;

    if ($balance_count == 0) {
        $sql_trip_update = "UPDATE tb_trip_main SET trip_status=1 where vehicle_no='" . $vehicle_no . "' and lsc_code = '" . $lsc_code . "' and tsc_code = '" . $tsc_code . "' and delete_status=0";
        $prepare = $pdo_conn->prepare($sql_trip_update);
        $exc = $prepare->execute();
    }

    return true;
}


function vehicle_trip_count_detail($vehicle_no, $lsc_code, $tsc_code)
{

    global $pdo_conn;
    $status = '';

    $booking_trip_count = $booking_hub_count = 0;
    $booking_dispatch_trip_count = $booking_dispatch_hub_count = 0;
    $in_trip = $in_hub = 0;

    $trip_sql_main = "SELECT * FROM `tb_trip_main` WHERE type IN ('Trip', 'Hub_Trip') AND vehicle_no = '$vehicle_no' AND lsc_code = '$lsc_code' AND tsc_code = '$tsc_code' AND delete_status = 0 AND trip_status = 0";
    $prepare = $pdo_conn->prepare($trip_sql_main);
    $exc = $prepare->execute();
    $trip_data = $prepare->fetchAll();

    foreach ($trip_data as $data) {
        if ($data['type'] == 'Trip') {
            $status = 2;
        } elseif ($data['type'] == 'Hub_Trip') {
            $status = 4;
        }

        $sql_booking = "SELECT IFNULL(COUNT(*),0) FROM tb_trip_sublist WHERE delete_status = 0 AND trip_id = '" . $data['id'] . "'";
        $prepare = $pdo_conn->prepare($sql_booking);
        $exc = $prepare->execute();
        if ($data['type'] == 'Trip') {
            $booking_trip_count += (int)$prepare->fetchColumn();
        } elseif ($data['type'] == 'Hub_Trip') {
            $booking_hub_count += (int)$prepare->fetchColumn();
        }

        $sql_booking = "SELECT IFNULL(COUNT(*),0) FROM tb_trip_sublist a INNER JOIN tb_booking_main b on a.booking_id=b.id WHERE a.delete_status = 0 and b.delete_status = 0 AND b.status > $status AND a.trip_id = '" . $data['id'] . "' ";
        $prepare = $pdo_conn->prepare($sql_booking);
        $exc = $prepare->execute();

        if ($data['type'] == 'Trip') {
            $booking_dispatch_trip_count += (int)$prepare->fetchColumn();
        } elseif ($data['type'] == 'Hub_Trip') {
            $booking_dispatch_hub_count += (int)$prepare->fetchColumn();
        }
    }
    $in_trip = ($booking_trip_count - $booking_dispatch_trip_count);
    $in_hub = ($booking_hub_count - $booking_dispatch_hub_count);

    return array(
        "balance_count"       => $in_hub + $in_trip,
        "trip_count"          => $booking_trip_count + $booking_hub_count,
        "despatch_count"      => $booking_dispatch_trip_count + $booking_dispatch_hub_count,
    );
}


function update_missing($booking_id, $missing_qty = 0, $trip_id =0, $status=0, $from_type = "")
{

    global $pdo_conn, $user_id;

    $get_qty = "SELECT IFNULL(SUM(m_quantity),0) AS tot_qty FROM tb_booking_sublist WHERE delete_status = 0 AND random_sc IN ( SELECT random_sc FROM tb_booking_main WHERE delete_status = 0 AND id = $booking_id )";
    $prepare = $pdo_conn->prepare($get_qty);
    $prepare->execute();
    $booking_qty = $prepare->fetchcolumn();


    $trip_qty = $booking_qty - $missing_qty;

    if ($status == 1) {
        $trip_qty = $missing_qty;
        $missing_qty = 0;

        $sql_unknow = "UPDATE unknown_entry SET status = 1 WHERE booking_id = $booking_id AND status = 0 AND  delete_status = 0";
        $prepare = $pdo_conn->prepare($sql_unknow);
        $exc = $prepare->execute();
    } else if ($missing_qty > 0) {

        $sql_booking = "SELECT booking_no FROM tb_booking_main WHERE delete_status = 0 AND id = $booking_id ";
        $prepare = $pdo_conn->prepare($sql_booking);
        $prepare->execute();
        $booking_no = $prepare->fetchcolumn();

        $save_data = array(
            "date"        => date("Y-m-d"),
            "booking_no"  => $booking_no,
            "booking_id"  => $booking_id,
            "qty"         => $missing_qty,
            "status"      => 0,
            "delete_status"=> 0,
            "type"        => $from_type,
            "created_by"  => $user_id,
        );
        $result =   save_data("missed_order", $save_data);
    }

    $sql_trip_sublist = "UPDATE tb_trip_sublist SET miss_qty = $missing_qty, trip_qty = $trip_qty WHERE booking_id = $booking_id AND type = '$from_type' AND trip_id = $trip_id AND delete_status = 0";
    $prepare = $pdo_conn->prepare($sql_trip_sublist);
    $exc = $prepare->execute();

    return ["get_qty" => $get_qty, "trip_update" => $sql_trip_sublist, "trip_qty" => $trip_qty, "booking_qty" => $booking_qty, "missing_qty" => $missing_qty, "trip_id" => $trip_id];
}

function trip_lr_status($trip_id)
{

    global $pdo_conn;
    $status = ''; $balance_lr=0;

    $sql_despach = "SELECT count(*) FROM tb_booking_main where id IN ( SELECT booking_id FROM tb_trip_sublist WHERE delete_status = 0 AND trip_id IN ($trip_id)) AND delete_status=0 and status>2";
          
    $prepare = $pdo_conn->prepare($sql_despach);
    $prepare->execute();
    $despatch_lr = $prepare->fetchcolumn();

    $sql_tot_lr = "SELECT count(*) FROM tb_booking_main where id IN ( SELECT booking_id FROM tb_trip_sublist WHERE delete_status = 0 AND trip_id IN ($trip_id)) AND delete_status=0 ";
          
    $prepare = $pdo_conn->prepare($sql_tot_lr);
    $prepare->execute();
    $total_lr = $prepare->fetchcolumn();
    
    $balance_lr = ($total_lr - $despatch_lr);

    if($balance_lr==0)
    {
        $status = '<i class="text-success">Completed<i>';
    }
    else
    {
        $status = '<i class="text-info">In Progress</i>';
    }

    return array(
        "balance"       => $balance_lr,
        "despatch"      => $despatch_lr,
        "total"         => $total_lr,
        "status"        => $status
    );
}
function get_complete_userinfo($user_id)
{
   global $pdo_conn;

    $totalcount = 0;
	
	$name =  '';

	$contact = '';

	$branch_code = '';

	$head_name = '';

    $name =  '';
	
	if($user_id!="")
	{

		$sql = "SELECT head_name,branch_code,contact_number FROM `user_creation` where user_id=".$user_id;

		$prepare = $pdo_conn->prepare($sql);

		$exc = $prepare->execute();

		if($exc == TRUE){

			$name  = $prepare->fetch();   
			
			$contact = $name['contact_number'];
				
			$branch_code = $name['branch_code'];
				
			$head_name = $name['head_name'];

		}

	}

    return $branch_code."-".$head_name."-".$contact; 
}


