
    $(document).ready(function(){  

    getCartDetails();

    const Toast = Swal.mixin({
    toast: true,
    position: 'bottom',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
    toast.addEventListener('mouseenter', Swal.stopTimer)
    toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
    });

    //common_wishlistalert
    $('.whishlistalert').on("click", function(){  

    Toast.fire({
    position:'center',
    icon: 'warning',
    title: 'You Must Login to wishlist',
    });  
    });

    //common_addtocartsection 
    $('.addtocart').on("click", function(){
    var val = $(this).attr('data-value'); 
    var $this = $(this);

    var stock_id='';


    $.ajax({
    url:"inc/action.php",
    method:"POST",
    dataType:'JSON',
    data:{
    'action':'addtocart',
    'product_id':val,
    'stock_id':stock_id,
    },
    beforeSend: function() {
    $this.addClass('isDisabled');
    //     Toast.fire({
    //     icon:'info',
    //     title: 'Loading...',
    //   });
    },
    success:function(data){
    $this.removeClass('isDisabled');
    Toast.fire({
    icon: data.status,
    title: data.message,
    });
    getCartDetails();

    },
    error:function(){
    Toast.fire({
    position:'center',
    icon:'warning',
    title:'Somthing went wrong !',
    })
    }
    });  
    })

    //common_cartpageqtyupdationfunction
    $('table.carttable').on('change', 'input[name="quantity"]', function(){
    var row = $(this).closest('tr');
    var quantity = +row.find('input[name="quantity"]').val();

    //  var minus_plus = $(this).attr('class');
    // if(minus_plus=='plus'){
    //    var span = (+quantity+1);
    //    if(span==0){ return false;}

    //    var quantity = row.find('#value').text(span);
    //     +row.find('input[name="quantity"]').val(span);
    // }else{
    //  var span = (+quantity-1);
    //  if(span==0){ return false;}
    //    var quantity = row.find('#value').text(span);
    //     +row.find('input[name="quantity"]').val(span);
    // }

    var price = +row.find('input[name="price"]').val();
    var cartid = +row.find('input[name="cartid"]').val();
    if(quantity>0){ 
    +row.find('input[name="row_total"]').val(quantity*price);
    row.find('#span_row_total').text((quantity*price).toFixed(2));
    calculateTotal(); 
    var couponname = $('#couponname').val();
    // if(couponname!=''||couponname!=null){
    //   coupon_function();
    // }
    $.ajax({
    method:'POST',
    url:'inc/action.php',
    dataType:'JSON',
    data:{
    'action':'update_cart',
    'cart_id':cartid,
    'quantity':quantity,
    },
    beforeSend: function() {
    //     Toast.fire({
    //     icon:'info',
    //     title: 'Loading...',
    //   });
    },
    success:function(data){ 
    //  Toast.fire({
    //     icon: data.status,
    //     title:  data.message,
    //   });

    getCartDetails();
    }
    })
    }else{
    Toast.fire({
    icon: 'warning',
    title:  'Qty should be greater than 0',
    })    

    }


    });


    function calculateTotal() {
    var totalValue=0;
    $('table.carttable').find('input[name="row_total"]').each(function(event){
    totalValue += +$(this).val();
    });
    $('#subtotal').val(totalValue.toFixed(2));
    $('#span_subtotal').text(totalValue.toFixed(2));
    $('#grandtotal').val(totalValue.toFixed(2));
    $('#span_grandtotal').text(totalValue.toFixed(2));

    }


    //cartitemremovefunction
    $('.carttable').on('click', '.removecart', function(){
    //  alert('test');
    var row = $(this).closest('tr');
    var cartid = +row.find('input[name="cartid"]').val(); 

    Swal.fire({
    title: 'Are you sure?',
    text: "You want to remove this Item!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Yes, Remove it!'
    }).then((result) => {
    if (result.value) { 
    $(this).closest('tr').remove();
    $.ajax({
    method:'POST',
    url:'inc/action.php',
    data:{
    'action':'cart_delete',
    'cart_id':cartid
    },
    dataType:'JSON',
    beforeSend: function() {
    Toast.fire({
    icon:'info',
    title: 'Loading...',
    });
    },
    success:function(data){  
    Toast.fire({
    position: 'center',
    icon: 'success',
    title: 'Cart Product Deleted Successfully..',
    });
    calculateTotal();
    getCartDetails();
    // $('#applycoupon').click();
    if($('table.carttable tbody').html()==''){

    }
    }
    })
    }
    });
    });

    //applycouponfunction
    $('#applycoupon').on('click', function(){
    var coupon= $('#couponname').val();
    var subtotal= $('#subtotal').val();


    if(coupon ==''||coupon ==null){}else{  
    $.ajax({
    method:'GET',
    url:'https://www.kancheepuramsmsilks.in/cart/checkCoupon/'+coupon+'/'+subtotal,
    dataType:'JSON',
    beforeSend: function() {
    Toast.fire({
    icon:'info',
    title: 'Loading...',
    });

    },
    success:function(data){   
    Toast.fire({
    position:'center',
    icon: data.status,
    title:data.message,
    });  
    if(data.status=='success'){
    $('#coupon_value').val(data.coupon_value);
    $('#span_coupon_value').text(data.coupon_value.toFixed(2));
    $('#grandtotal').val($('#subtotal').val()-data.coupon_value);
    $('#span_grandtotal').text($('#subtotal').val()-data.coupon_value);
    }else{
    $('#coupon_value').val(0);
    $('#span_coupon_value').text('0.00');
    $('#span_grandtotal').text(subtotal);
    $('#grandtotal').val(subtotal);
    }
    }
    })
    }


    });


    function coupon_function() {                          
    var coupon= $('#couponname').val();
    var subtotal= $('#subtotal').val();
    if(coupon ==''||coupon ==null){}else{  
    $.ajax({
    method:'GET',
    url:'https://www.kancheepuramsmsilks.in/cart/checkCoupon/'+coupon+'/'+subtotal,
    dataType:'JSON',
    beforeSend: function() {
    },
    success:function(data){    
    if(data.status=='success'){
    $('#coupon_value').val(data.coupon_value);
    $('#span_coupon_value').text(data.coupon_value.toFixed(2));
    $('#grandtotal').val($('#subtotal').val()-data.coupon_value);
    $('#span_grandtotal').text($('#subtotal').val()-data.coupon_value);
    }else{
    $('#coupon_value').val(0);
    $('#span_coupon_value').text('0.00');
    $('#span_grandtotal').text(subtotal);
    $('#grandtotal').val(subtotal);
    }
    }
    })
    }

    }


    //common_carttotalanddetailfunction 
    function getCartDetails() {

    $.ajax({
    method:'GET',
    url:'inc/action.php',
    dataType:'JSON',
    success:function(data){
    // console.log(data);
    var  count=0;
    var items='';
    var cart_total=0;

    if(data.wishlist !=null){   
    for (var w = 0; w < data.wishlist.length; w++) {

    $("a.addtowishlist").each(function() {
    if ($(this).attr('data-value')) {
    var product_id = $(this).attr('data-value');       
    if(data.wishlist[w].product_id==product_id){
    $(this).find('i').removeClass('fa-heart');
    $(this).find('i').addClass('fa-heart-o colorred');
    }
    }
    });
    }
    }

    if(data.data!=null){       
    for (var i = 0; i < data.data.length; i++) {

    $("a.addtocart").each(function() {
    if ($(this).attr('data-value')) {
    var product_id = $(this).attr('data-value');       
    if(data.data[i].product_id==product_id){
    $(this).find('i').removeClass('fa-shopping-bag');
    $(this).find('i').addClass('fa-shopping-basket colorred');
    }
    }
    }); 
    var link = $('body').find('a').attr('data-value');
    if(link==data.data[i].cart_id){ 
    console.log(link);
    }
    count +=+data.data[i].quantity;  
    cart_total +=(data.data[i].quantity * data.data[i].price);  
    items +='<li><a  class="photo"><img src="https://www.kancheepuramsmsilks.in/admin/'+data.data[i].image+'" class="cart-thumb" alt="" /></a><h6><a href="#">'+data.data[i].item_title+'</a></h6><p>'+data.data[i].quantity+'x - <span class="price">₹ '+data.data[i].price+'</span></p></li>';
    }
    $('.cart-list').text('');
    $('.cart-list').append(items+'<li class="total"><span class="pull-right"><strong>Total</strong>:  ₹ '+cart_total.toFixed(2)+'</span><a href="https://www.kancheepuramsmsilks.in/cart" class="btn btn-default btn-cart">Cart</a></li>');
    $('#cartcount').text(count);



    }else{
            }



    }
    });
    };

    //common_subscribefunction
    $('#subscribe').on("click", function(){
    var val = $('#subscribe_email').val(); 
    $.ajax({
    url:"https://www.kancheepuramsmsilks.in/home/addsubs/"+val,
    method:"GET",
    dataType:'JSON',
    beforeSend: function() {
    Toast.fire({
    icon:'info',
    title: 'Loading...',
    });
    },
    success:function(data){
    Swal.fire({
    icon: data.status,
    title: data.message,
    showConfirmButton: false,
    timer: 2500
    });  
    }
    });  
    });

    //common_wishlistaddingfunction

    $('.addtowishlist').on("click", function(){
    var val = $(this).attr('data-value');

    // if($(this).find('i').hasClass('fa-heart')){
    // $(this).find('i').removeClass('fa-heart');
    // $(this).find('i').addClass('fa-heart-o colorred');    
    // }else{
    //     $(this).find('i').removeClass('fa-heart-o colorred');
    //     $(this).find('i').addClass('fa-heart');    
    // };


    $.ajax({
    url:"inc/action.php",
    method:"POST",
    dataType:'JSON',
    data:{
    'action':'addtowishlist',
    'product_id':val
    },
    beforeSend: function() {
    //   Toast.fire({
    //   icon:'info',
    //   title: 'Loading...',
    // });
    },
    success:function(data){
    Toast.fire({
    icon: data.status,
    title: data.message,
    })
    }
    });

    })



    $('.wishlisttable').on('click', '.removecart', function(){
    //  alert('test');
    var row = $(this).closest('tr');
    var cartid = +row.find('input[name="cartid"]').val(); 

    Swal.fire({
    title: 'Are you sure?',
    text: "You want to remove this Item!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Yes, Remove it!'
    }).then((result) => {
    if (result.value) { 
    $(this).closest('tr').remove();
    $.ajax({
    method:'POST',
    url:'inc/action.php',
    data:{
    'action':'cart_delete',
    'cart_id':cartid
    },
    dataType:'JSON',
    beforeSend: function() {
    Toast.fire({
    icon:'info',
    title: 'Loading...',
    });
    },
    success:function(data){  
    Toast.fire({
    position: 'center',
    icon: 'success',
    title: 'Wishlist Product Deleted Successfully..',
    });
    calculateTotal();
    getCartDetails();
    // $('#applycoupon').click();
    if($('table.wishlisttable tbody').html()==''){

    }
    }
    })
    }
    });
    });


      $('.addtocompare').on("click", function(){
    var val = $(this).attr('data-value');
    $.ajax({
    url:"inc/action.php",
    method:"POST",
    dataType:'JSON',
    data:{
    'action':'addtocompare',
    'product_id':val
    },
    beforeSend: function() {
    },
    success:function(data){
    Toast.fire({
    icon: data.status,
    title: data.message,
    })
    }
    });

    });

           $('.removecompare').on("click", function(){
    var val = $(this).attr('data-value');
    $.ajax({
    url:"inc/action.php",
    method:"POST",
    dataType:'JSON',
    data:{
    'action':'removecompare',
    'product_id':val
    },
    beforeSend: function() {
    },
    success:function(data){
    Toast.fire({
    icon: data.status,
    title: data.message,
    });
    location.reload();
    }
    });

    });


    $('.removeall_compare').on("click", function(){
    $.ajax({
    url:"inc/action.php",
    method:"POST",
    dataType:'JSON',
    data:{
    'action':'removeall_compare',
    },
    beforeSend: function() {
    },
    success:function(data){
    location.reload();
    }
    });

    });


           


      


    })
  