<?php
ob_start();
session_start();
require_once "dbconnect.php";

date_default_timezone_set("Asia/Kolkata");

/*---------- Execute Mysql Select function ----------*/
 

function get_unique_id()

{

    $unique = uniqid() . rand(100000, 999999);

    return $unique;
}

 

function amount_inr_format($amount)

{

    $amount = round($amount, 2);



    $amountArray =  explode('.', $amount);



    if (count($amountArray) == 1) {

        $int = $amountArray[0];

        $des = 00;
    } else {

        $int = $amountArray[0];

        $des = $amountArray[1];
    }

    if (strlen($des) == 1) {

        $des = $des . "0";
    }

    if ($int >= 0) {

        $int = numFormatIndia($int);

        $themoney = $int . "." . $des;
    } else {

        $int = abs($int);

        $int = numFormatIndia($int);

        $themoney = "-" . $int . "." . $des;
    }



    return $themoney;
}





function numFormatIndia($num)

{



    $explrestunits = "";

    if (strlen($num) > 3) {

        $lastthree = substr($num, strlen($num) - 3, strlen($num));

        $restunits = substr($num, 0, strlen($num) - 3);

        $restunits = (strlen($restunits) % 2 == 1) ? "0" . $restunits : $restunits;

        $expunit = str_split($restunits, 2);

        for ($i = 0; $i < sizeof($expunit); $i++) {



            if ($i == 0) {

                $explrestunits .= (int)$expunit[$i] . ",";
            } else {

                $explrestunits .= $expunit[$i] . ",";
            }
        }

        $thecash = $explrestunits . $lastthree;
    } else {

        $thecash = $num;
    }

    return $thecash;
}







function query($sql = "")

{

    global $pdo_conn;



    $result = "";
    $count = 0;
    $response = array();



    $prepare         = $pdo_conn->prepare($sql);



    $selectcustomer  = $prepare->execute();



    $result          = $prepare->fetchAll(PDO::FETCH_ASSOC);



    $count           = count($result);



    $response        = array(



        'sql'      => $sql,

        'data'     => $result,

        'count'    => $count

    );



    return $response;
}








/*---------- Execute Mysql Insert function ----------*/



function save_data($table, $value)

{

    global $pdo_conn;



    $data = "";
    $result = array();
    $last_id = 0;



    $table = $table;



    $fields = implode(',', array_keys($value));

    $values = implode(',', array_values($value));



    $fieldParam = ':' . implode(',:', array_keys($value));



    $binding = array_combine(explode(',', $fieldParam), $value);



    $sql       = "INSERT INTO $table ($fields) VALUES ($fieldParam)";

    $prepare   = $pdo_conn->prepare($sql);

    $executed  = $prepare->execute($binding);

    $last_id   = $pdo_conn->lastInsertId();



    /*----------- Ref sql --------------------*/



    foreach ($value as  $value) {

        $data   .= "'" . $value . "',";
    }

    $data    = rtrim($data, ',');

    $ref_sql = "INSERT INTO $table ($fields) VALUES ($data)";



    /*-----------------------------------------*/



    $result = array(

        'sql'         => $ref_sql,

        'result'     => $executed,

        'last_id'     => $last_id



    );



    return $result;
}





/*------- Execute Mysql Update function ----*/



function update_data($table, array $value, $where = null)

{

    global $pdo_conn;

    $result     = array();

    $fields     = implode(',', array_keys($value));

    $values     = implode(',', array_values($value));



    $fieldParam = ':' . implode(',:', array_keys($value));



    $binding     = array_combine(explode(',', $fieldParam), $value);



    $BindfieldParam = implode(', ', array_map(function ($field, $param) {
        return $field . '=' . $param;
    }, array_keys($value), array_keys($binding)));



 $sql = "UPDATE $table SET $BindfieldParam";



    if (is_array($where) && count($where) != 0) {



        $where = array_map(function ($value, $key) {

            return $key . "='" . $value . "'";
        }, $where, array_keys($where));



        $where     = implode(' AND ', $where);
    }



    if (!empty($where) && $where !== null) {

        $sql     .= " WHERE " . $where;
    }

    $prepare     = $pdo_conn->prepare($sql);

    $executed     = $prepare->execute($binding);



    /*--------- Ref Update Sql ----------*/



    $ref_sql  = "";
    $update_value = "";
    $update = "";

    $ref_sql .= "UPDATE $table SET ";



    foreach ($value as $key => $data) {

        $update_value .= "" . $key . "='" . $data . "',";
    }

    $update .= rtrim($update_value, ',');

    $ref_sql .= $update . 'WHERE ' . $where;



    $result = array(



        'sql'      => $ref_sql,

        'result' =>    $executed



    );



    return $result;
}



/*------------ Get User IP Address ------------- */



function get_ip_address()
{

    $ipaddress = '';

    if ($_SERVER['REMOTE_ADDR'] != '')

        $ipaddress = $_SERVER['REMOTE_ADDR'];

    else if ($_SERVER['REMOTE_HOST'] != '')

        $ipaddress = $_SERVER['REMOTE_HOST'];

    else if (getenv('HTTP_CLIENT_IP'))

        $ipaddress = getenv('HTTP_CLIENT_IP');

    else if (getenv('HTTP_X_FORWARDED_FOR'))

        $ipaddress = getenv('HTTP_X_FORWARDED_FOR');

    else if (getenv('HTTP_X_FORWARDED'))

        $ipaddress = getenv('HTTP_X_FORWARDED');

    else if (getenv('HTTP_FORWARDED_FOR'))

        $ipaddress = getenv('HTTP_FORWARDED_FOR');

    else if (getenv('HTTP_FORWARDED'))

        $ipaddress = getenv('HTTP_FORWARDED');

    else if (getenv('REMOTE_ADDR'))

        $ipaddress = getenv('REMOTE_ADDR');

    else

        $ipaddress = 'UNKNOWN';

    return $ipaddress;
}

/*----------- Total found Columns ----------*/



function found_rows_count()
{

    global $pdo_conn;

    $totalcount = 0;

    $sql = "SELECT FOUND_ROWS() as total";

    $prepare = $pdo_conn->prepare($sql);

    $exc = $prepare->execute();

    if ($exc == TRUE) {

        $list = $prepare->fetchAll();



        $totalcount = $list[0];
    }



    return $totalcount['total'];
}





/*-------- Get Correct Date Formate ---*/



function date_month_year($date_value)

{

    $date_create = date_create($date_value);

    $date = date_format($date_create, 'd-m-Y');

    return $date;
}

function date_month_year_time($date_value)

{

    $date_value=strtotime($date_value);
    $date = date("d-m-Y", $date_value);
    $time = date("h:i:s a", $date_value);

    $date_str = "<div>$date</div><span style='font-size:10px'>$time</span>";

    // $date = date_format($date_create, 'd-m-Y');

    return $date_str;
}



/*------- Files Upload Function ------*/



// $path       =  "../staff_upload_files/";

// $title      =  "Documents";

// $extensions =  array("jpeg","jpg","png");

// $result     =  files_uploading($_FILES['documents'],$path,$title,$extensions);



function files_uploading($base_file, $path, $title, $extensions)

{

    $saved_name = array();

    $date         = date('m-d-Y');

    $count      = count($base_file['name']);



    for ($i = 0; $i < $count; $i++) {



        $random     = rand(0000, 9999);

        $file_name = $base_file['name'][$i];

        $file_size = $base_file['size'][$i];

        $file_tmp  = $base_file['tmp_name'][$i];

        $file_type = $base_file['type'][$i];



        $ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

        $upload_path  = $path . $title . '-' . ($i + 1) . '-' . $date . '-' . $random . '.' . $ext;

        if (in_array($ext, $extensions)) {

            $result   = move_uploaded_file($file_tmp, $upload_path);

            if ($result == true) {

                $saved_name[] = $upload_path;
            }
        }
    }



    return $saved_name;
}



function acc_year_using_date($date = "")

{

    $acc_year  = "";

    $from_year = "";

    $to_year   = "";



    if ($date != "") {

        $explode  = explode('-', $date);

        $year     = $explode[0];

        $month    = $explode[1];

        $day      = $explode[2];

        if ($month > 3) {

            $from_year  = $year;

            $to_year    = $year + 1;
        } else {

            $from_year = $year - 1;

            $to_year   = $year;
        }
    } else {

        $from_year = date('Y');

        $to_year   = $from_year + 1;
    }

    $acc_year = $from_year . '-' . $to_year;



    return $acc_year;
}





function no_to_words($no)

{

    $words = array('0' => '', '1' => 'ONE', '2' => 'TWO', '3' => 'THREE', '4' => 'FOUR', '5' => 'FIVE', '6' => 'SIX', '7' => 'SEVEN', '8' => 'EIGHT', '9' => 'NINE', '10' => 'TEN', '11' => 'ELEVEN', '12' => 'TWELVE', '13' => 'THIRTEEN', '14' => 'FOURTEEN', '15' => 'FIFTEEN', '16' => 'SIXTEEN', '17' => 'SEVENTEEN', '18' => 'EIGHTEEN', '19' => 'NINETEEN', '20' => 'TWENTY', '30' => 'THIRTY', '40' => 'fourty', '50' => 'FIFTY', '60' => 'SIXTY', '70' => 'SEVENTY', '80' => 'EIGHTY', '90' => 'NINTY', '100' => 'HUNDRED AND', '1000' => 'THOUSAND', '100000' => 'LAKH', '10000000' => 'CRORE');

    if ($no == 0)

        return ' ';

    else {

        $novalue = '';

        $highno = $no;

        $remainno = 0;

        $value = 100;

        $value1 = 1000;

        while ($no >= 100) {

            if (($value <= $no) && ($no  < $value1)) {

                $novalue = $words["$value"];

                $highno = (int)($no / $value);

                $remainno = $no % $value;

                break;
            }

            $value = $value1;

            $value1 = $value * 100;
        }

        if (array_key_exists("$highno", $words))

            return $words["$highno"] . " " . $novalue . " " . no_to_words($remainno);

        else {

            $unit = $highno % 10;

            $ten = (int)($highno / 10) * 10;

            return $words["$ten"] . " " . $words["$unit"] . " " . $novalue . " " . no_to_words($remainno);
        }
    }
}







function get_roll_action_permission($page_name, $short_name, $userroll)
{

    $status = '0';

    $sql_page = "SELECT userform_id FROM userform WHERE short_name ='" . $page_name . "' ";

    $data1  = query($sql_page);

    if ($data1['count'] == 1) {

        $list_page = $data1['data'][0];

        $sql = "SELECT userform_id FROM userform WHERE short_name ='" . $short_name . "' AND sub_id ='" . $list_page['userform_id'] . "'";

        $query1  = query($sql);

        if ($query1['count'] == 1) {

            $list_1 = $query1['data'][0];

            $sql_1 = "SELECT status FROM userformrights  WHERE roll_id ='" . $userroll . "' AND form_id ='" . $list_1['userform_id'] . "' ";

            $query2  = query($sql_1);

            if ($query2['count'] == 1) {

                $status = $query2['data'][0]['status'];
            }
        }
    }

    return $status;
}

function get_username($user_id)
{
    global $pdo_conn;

    $totalcount = 0;

    $name =  '';

    $contact = '';

    $branch_code = '';

    $head_name = '';

    $name =  '';

    if ($user_id != "") {

        $sql = "SELECT head_name,branch_code,contact_number FROM `user_creation` where user_id=" . $user_id;

        $prepare = $pdo_conn->prepare($sql);

        $exc = $prepare->execute();

        if ($exc == TRUE) {

            $name  = $prepare->fetch();

            $contact = $name['contact_number'];

            $branch_code = $name['branch_code'];

            $head_name = $name['head_name'];
        }
    }
// . "-" . $head_name . "-" . $contact
    return $branch_code."-" . $head_name;
}
 

 function get_product($id='')
{
     global $pdo_conn;

      $sql = "SELECT * FROM `tp_product` where id='".$id."'";

        $prepare = $pdo_conn->prepare($sql);

        $exc = $prepare->execute();

        if ($exc == TRUE) {

            $data  = $prepare->fetch();
        }

        return $data;
}