import React, { useEffect, useRef, useContext } from "react";
import { FaCalendarAlt, FaMapMarkerAlt, FaTag } from "react-icons/fa"; // Fixed imports
import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Autoplay } from "swiper/modules";
import "swiper/css";
import "swiper/css/navigation";
import { gsap } from "gsap";
import { PropsContext } from "../../../context/PropsContext";
import { FiChevronsRight } from "react-icons/fi";

const EventsSection = () => {
  const sectionRef = useRef(null);
  const { formattedEvents } = useContext(PropsContext);

  useEffect(() => {
    gsap.fromTo(
      sectionRef.current.querySelectorAll(".cdiic-notice-card"),
      {
        opacity: 0,
        y: 40,
      },
      {
        opacity: 1,
        y: 0,
        duration: 0.8,
        stagger: 0.2,
        ease: "power2.out",
      }
    );
  }, []);

  return (
    <section className="py-5" ref={sectionRef}>
      <div>
        <div className="container">
          <div className="carouselSlider__container text-center">
            <div className="mb-4 text-center">
              <h6 className="fw-bold">Events</h6>
              <h2 className="fw-bold mb-3 text-dark">Events @ CDIIC</h2>
              <p className="text-dark text-center mb-4">
                Facilitating strong networks between MSMEs, DPSUs, and the Armed
                Forces.
              </p>
            </div>
            <div className="mt-5">
              {formattedEvents.length > 0 ? (
                <Swiper
                  modules={[Navigation, Autoplay]}
                  navigation={{
                    nextEl: ".carouselSlider__next",
                    prevEl: ".carouselSlider__prev",
                  }}
                  autoplay={{
                    delay: 3000,
                    disableOnInteraction: false,
                  }}
                  loop={true}
                  spaceBetween={20}
                  slidesPerView={1}
                  breakpoints={{
                    640: {
                      slidesPerView: 2,
                      spaceBetween: 20,
                    },
                    768: {
                      slidesPerView: 2,
                      spaceBetween: 20,
                    },
                    1024: {
                      slidesPerView: 3,
                      spaceBetween: 20,
                    },
                    1200: {
                      slidesPerView: 3,
                      spaceBetween: 20,
                    },
                    1400: {
                      slidesPerView: 3,
                      spaceBetween: 20,
                    },
                  }}
                  className="carouselSlider__swiper"
                >
                  {formattedEvents.map((event, index) => (
                    <SwiperSlide key={event.id}>
                      <div
                        className='carouselSlider__item-event-main'
                      >
                      
                        <img
                          className="img-fluid"
                          src={event.image || "https://placehold.co/600x400"}
                          alt={event.title}
                        />
                        <h3 className="carouselSlider__title mt-3">
                          {event.title}
                        </h3>
                        <p className="carouselSlider__content-main text-dark fw-800">
                          {event.subtitle}
                        </p>
                        {/* <div className="event-details">
                          <p className="credit-item location-item-main mb-2">
                            <span>
                              <FaCalendarAlt className="me-2" />
                            </span>

                            {
                              event.credits.find((c) =>
                                c.className.includes("date-item")
                              )?.text
                            }
                          </p>
                          <p className="credit-item location-item-main mb-2">
                            <span>
                              {" "}
                              <FaMapMarkerAlt className="me-2" />{" "}
                            </span>

                            {
                              event.credits.find((c) =>
                                c.className.includes("location-item")
                              )?.text
                            }
                          </p>
                          <p className="credit-item location-item-main mb-2">
                            <span>
                              <FaTag className="me-2" />
                            </span>
                            Status: {event.status}
                          </p>
                        </div> */}
                        <div className="btn-download mt-4">
                          <a href="/events">
                            Read More
                            <span className="ps-5">
                              <FiChevronsRight />
                            </span>
                          </a>
                        </div>
                      </div>
                    </SwiperSlide>
                  ))}
                </Swiper>
              ) : (
                <div className="text-center py-5">
                  <p>No events available at the moment.</p>
                </div>
              )}

              {formattedEvents.length > 0 && (
                <>
                  <button className="carouselSlider__prev carouselSlider__arrow">
                    &lt;
                  </button>
                  <button className="carouselSlider__next carouselSlider__arrow">
                    &gt;
                  </button>
                </>
              )}
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default EventsSection;
