import { FiGitCommit } from "react-icons/fi";
export default function Business() {
  return (
    <section className="business-sec sec-ptb" data-aos="fade-up">
      <div className="container">
        <div className="sec-title text-center">
          <h2 data-aos="fade-up" data-aos-delay="100">
            Support at CDIIC
          </h2>
        </div>
        <div className="row mt-3">
          <div className="col-lg-6">
            <div className="sec-content h-100 d-flex justify-content-center flex-column">
              {[
                "Requirement Coordination & Project Management for Indigenization between All Defence Forces, DPSUs & Regional MSME's",
                "Memberships, News Letters and Events to Outreach messages to all CDIIC members of our Defence corridor",
                "Incubation Center - Working space for creating Ecosystem for startup",
                "Networking with Defence Units, Other Industrial bodies, Academic Institutions, Industries, VC and Funding agencies",
                "Training and Development - Incubators and Skill Development",
                "Engineering Services - Indigenization with available resources",
                // "CDIIC — Catalyzing innovation in Global and Defence Applications",
                // "CDIIC — Synergizing with Startup, MSMEs. Defence forces and DPSUs",
                // "CDIIC—India's First Defence Innovation Hub Coordinating Indigenization effort taken by Government under Make in India with MSMEs / Startups",
              ].map((text, index) => (
                <p
                  key={index}
                  className="sec-text d-flex"
                  data-aos="fade-up"
                  data-aos-delay={`${150 + index * 50}`}
                >
                  <div className="pe-3 support-text">
                    <span>
                      <FiGitCommit />
                    </span>
                  </div>
                  <div>{text}</div>
                </p>
              ))}
            </div>
          </div>
          <div className="col-lg-6 tab-col-gap">
            <div
              className="sec-images-grid"
              data-aos="fade-up"
              data-aos-delay="200"
            >
              <div
                className="landscape-img"
                data-aos="fade-up"
                data-aos-delay="300"
              >
                <img
                  src="/images/home/support-1.png"
                  alt="Landscape"
                  className="img-fluid"
                />
              </div>
              <div className="portrait-images">
                <img
                  src="/images/home/support-2.png"
                  alt="Portrait 1"
                  className="img-fluid"
                  data-aos="fade-up"
                  data-aos-delay="350"
                />
                <img
                  src="/images/home/support-3.png"
                  alt="Portrait 2"
                  className="img-fluid"
                  data-aos="fade-up"
                  data-aos-delay="400"
                />
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
