import { useContext } from "react";
import { PropsContext } from "../../../context/PropsContext";
import NewsGalleryCard from "../../ui/cards/NewsGalleryCard";

export default function Newsgallery() {
  const { formattedNewsGallery, newsGalleryPagination, fetchNewsGalleryData } = useContext(PropsContext);

  const handlePageChange = (page) => {
    if (page >= 1 && page <= newsGalleryPagination.last_page) {
      fetchNewsGalleryData(page);
    }
  };

  const isFirstPage = newsGalleryPagination.current_page === 1;
  const isLastPage = newsGalleryPagination.current_page === newsGalleryPagination.last_page;

  return (
    <section className="project-sec2 sec-ptb">
      <div className="container">
        <div className="row">
          <div className="offset-lg-3 col-lg-6">
            <div className="sec-content text-center mb-5">
              <h6 className="sec-sub-title">Our News Gallery</h6>
              <h2 className="sec-title">News & Events</h2>
            </div>
          </div>
        </div>

        <div className="row">
          {formattedNewsGallery.length > 0 ? (
            formattedNewsGallery.map((item, index) => (
              <div className="col-md-6 col-lg-4" key={item.id}>
                <NewsGalleryCard data={item} index={index} />
              </div>
            ))
          ) : (
            <p className="text-center">No news gallery items found.</p>
          )}
        </div>

        {/* Pagination */}
        <div className="pagination-wrapper text-center mt-4">
          <button
            className="btn btn-outline-secondary mx-1"
            onClick={() => handlePageChange(newsGalleryPagination.current_page - 1)}
            disabled={isFirstPage}
          >
            &laquo; 
          </button>

          {[...Array(newsGalleryPagination.last_page)].map((_, i) => (
            <button
              key={i + 1}
              onClick={() => handlePageChange(i + 1)}
              className={`btn btn-sm mx-1 ${newsGalleryPagination.current_page === i + 1 ? "btn-primary" : "btn-outline-primary"}`}
            >
              {i + 1}
            </button>
          ))}

          <button
            className="btn btn-outline-secondary mx-1"
            onClick={() => handlePageChange(newsGalleryPagination.current_page + 1)}
            disabled={isLastPage}
          >
             &raquo;
          </button>
        </div>
      </div>
    </section>
  );
}