import React, { useEffect, useState, useContext } from "react";
import { PropsContext } from "../../../context/PropsContext";

const NewsGalleryDetail = ({ id}) => {
  const { fetchNewsGalleryDetailById } = useContext(PropsContext);
  const [images, setImages] = useState([]);
  const baseURL = "https://icloudcs.in/CDIIC/public/";
  useEffect(() => {
    console.log("Fetching news gallery for ID:", id);
    const loadData = async () => {
      const data = await fetchNewsGalleryDetailById(id);
      if (data.length) {
        
        setImages(data);
      } else {
       
        setImages([]);
      }
    };
    loadData();
  }, [id]);

  return (
    <div className="container py-5">
      <h2 className="text-center mb-4">News Gallery Detail - ID {id}</h2>
      <div className="row">
        {images.map((img) => {
          const fullUrl = `${baseURL}${img.image_path}`;
          return (
            <div key={img.id} className="col-lg-3 col-md-4 col-sm-6 mb-4">
              <div className="border shadow-sm rounded p-2 h-100">
                
                <img
                  src={fullUrl}
                  alt={`Image ${img.id}`}
                  className="img-fluid w-100 rounded"
                  style={{ height: "200px", objectFit: "cover" }}
                  onError={() =>
                    console.error("Image failed to load:", fullUrl)
                  }
                />
              </div>
            </div>
          );
        })}
      </div>
    </div>
  );
};

export default NewsGalleryDetail;
