import { Link } from "react-router-dom";
import "swiper/css";
import "swiper/css/navigation";
import { Autoplay, Navigation, Pagination } from "swiper/modules";
import { Swiper, SwiperSlide } from "swiper/react";
import { FiChevronRight, FiChevronLeft } from "react-icons/fi";
import { useEffect, useRef, useState } from "react";
import { LuCheckCheck } from "react-icons/lu";

export default function Project() {
  const [slideHeight, setSlideHeight] = useState(0);
  const [activeIndex, setActiveIndex] = useState(0);
  const rightColRef = useRef(null);
  const [activeTab, setActiveTab] = useState("Atal Incubation Centre");
  const [screenWidth, setScreenWidth] = useState(window.innerWidth);

  useEffect(() => {
    const handleResize = () => setScreenWidth(window.innerWidth);
    window.addEventListener("resize", handleResize);
    return () => window.removeEventListener("resize", handleResize);
  }, []);
  // Defence slider images
  const defenceSliderImages = [
    "/images/project/defence/1.jpg",
    "/images/project/defence/2.jpg",
    "/images/project/defence/3.jpg",
    "/images/project/defence/4.jpg",
  ];

  // Atal slider images
  const atalSliderImages = [
    "/images//project/atal/1.jpg",
    "/images//project/atal/2.jpg",
    "/images//project/atal/3.jpg",
    "/images//project/atal/4.jpg",
    "/images//project/atal/5.jpg",
    "/images//project/atal/6.jpg",
    "/images//project/atal/7.jpg",
  ];

  const currentSliderImages =
    activeTab === "Defence Innovation Centre"
      ? defenceSliderImages
      : atalSliderImages;

  useEffect(() => {
    if (rightColRef.current) {
      const height = rightColRef.current.offsetHeight;
      setSlideHeight(height);
    }
  }, []);

  const defenceObjectives = {
    items: [
      "Identifying requirement of Defence Forces and Defence PSUs.",
      "Mapping capabilities of MSMEs in and around Coimbatore",
      "Analysing the assistance required by the MSMEs and incubating their ideas.",
      "Creating necessary infrastructure to innovate, develop and test the products and services developed by MSMEs, needed for the Defence Establishments.",
      "Create linkages with educational institutions having technical expertise to design new products.",
    ],
  };

  const atalObjectives = {
    items: [
      "Supporting innovative technology-based startup enterprises in India.",
      "Establish a high-class incubation facility, including but not limited to: physical infrastructure, capital equipment, and operational support.",
      "Enable support ecosystem for incubated startups, including but not limited to: mentoring, planning, organizing events, lab facilities, regulatory guidance, etc.",
      "Provide preference in support to startups or innovators that have applications / impact in the core sectors of the economy (e.g. agriculture, healthcare, clean energy and sustainable technologies, education, housing, transportation, Cyber security, IOT, Robotics and AI, water and sanitation, etc.)",
      "Encourage innovation in the Indian ecosystem, through activities such as, but not limited to, hackathons, idea competitions, etc.",
    ],
  };

  const currentObjectives =
    activeTab === "Defence Innovation Centre"
      ? defenceObjectives
      : atalObjectives;

  return (
    <section className="project-sec sec-ptb">
      <div className="container">
        <div className="sec-title text-center">
          <h2>CDIIC Objectives</h2>
        </div>
        <div className="d-flex justify-content-center align-items-center">
          <img
            src="/images/hero/objectives.png"
            alt="about-img objectives-img"
            className="h-100 p-2"
          />
        </div>

        <div className="row">
          <div  className="col-sm-12 col-md-9 col-lg-6 col-xl-6 m-auto">
            <div className="project-slider pt-5">
              <Swiper
                spaceBetween={30}
                navigation={{
                  nextEl: ".owl-next",
                  prevEl: ".owl-prev",
                }}
                pagination={{
                  el: ".swiper-pagination",
                  type: "progressbar",
                }}
                modules={[Navigation, Autoplay, Pagination]}
                loop={true}
                autoplay={{
                  delay: 2200,
                  disableOnInteraction: false,
                  pauseOnMouseEnter: true,
                }}
                onSlideChange={(swiper) => setActiveIndex(swiper.realIndex)}
                breakpoints={{
                  0: { slidesPerView: 1 },
                  425: { slidesPerView: 1 },
                  576: { slidesPerView: 1 },
                  767: { slidesPerView: 1 },
                  992: { slidesPerView: 1 },
                }}
              >
                {currentSliderImages.map((imgUrl, i) => (
                  <SwiperSlide key={i}>
                    <div className="item single-project h-100">
                      <div className="project-img h-100">
                        <img
                          src={imgUrl}
                          alt={activeTab}
                          className="h-100 w-100 object-cover img-fluid"
                        />
                      </div>
                      <div className="project-title">
                        <h5>
                          <Link to="#">{activeTab}</Link>
                        </h5>
                        {/* <span className="project-cat">Image {i + 1}</span> */}
                      </div>
                    </div>
                  </SwiperSlide>
                ))}
              </Swiper>
              <div className="owl-nav">
                <a
                  href="#"
                  onClick={(e) => e.preventDefault()}
                  className="owl-prev"
                >
                  <FiChevronLeft />
                </a>
                <a
                  href="#"
                  onClick={(e) => e.preventDefault()}
                  className="owl-next"
                >
                  <FiChevronRight />
                </a>
              </div>
            </div>
          </div>

          <div
            className="col-sm-12 col-md-9 col-lg-6 col-xl-6 m-auto"
            ref={rightColRef}
          >
            <div className="project-slider pt-5 h-100">
              <div className="project-tabs mb-3">
                <button
                  className={`tab-btn ${
                    activeTab === "Defence Innovation Centre" ? "active" : ""
                  }`}
                  onClick={() => setActiveTab("Defence Innovation Centre")}
                >
                  Defence Innovation Centre
                </button>
                <button
                  className={`tab-btn ${
                    activeTab === "Atal Incubation Centre" ? "active" : ""
                  }`}
                  onClick={() => setActiveTab("Atal Incubation Centre")}
                >
                  Atal Incubation Centre
                </button>
              </div>

              <div className="sec-content h-100">
                <ul className="objectives-list">
                  {(screenWidth <= 992
                    ? currentObjectives.items
                    : currentObjectives.items
                  ).map((item, index) => (
                    <li
                      key={index}
                      className={activeIndex === index ? "active" : ""}
                    >
                      <div className="progress-bar-wrapper">
                        {activeIndex === index && (
                          <div className="progress-bar" />
                        )}
                      </div>
                      <span className="check-icon">
                        <LuCheckCheck />
                      </span>
                      <div className="objective-text">{item}</div>
                    </li>
                  ))}
                </ul>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
