import React, { useRef } from 'react';
import { gsap } from 'gsap';
import { ScrollTrigger } from 'gsap/ScrollTrigger';


// Register GSAP plugins
gsap.registerPlugin(ScrollTrigger);

const Incubatees = () => {
  const cardRefs = useRef([]);
  const titleRef = useRef(null);
  const containerRef = useRef(null);

  // Sample data for incubatees
  const incubateesData = [
    {
      id: 1,
      title: "Appville Softwares",
      description: "Appville Softwares provides solutions to Industry 4.0 problems and gives the strategy to transform to a smart factory. Our solutions includes mobile apps for Android and iOS.We develop rugged android app solutions for users all over the world. Mobile app solutions including GPS, delivery schedule and other Retail and engineering solutions are a proven chest in our portfolio. Our other solutions includes Augmented reality, Virtual reality, Mixed reality, Industrial IOT, Digital twin and digitalization. In these way, any manufacturing company, would transform itself to manufacturing 4.0 strategy.",
                          image: "/images/incubatees/cover/1.png",
      logo: "/images/incubatees/1.png"
    },
    {
      id: 2,
      title: "Arputha Technologies",
      description: "Established in January, 2020, Arputha Technologies is a product development company amongst the industry leading manufacturer and supplier. The company excites its customer with its products focusing on latest technologies in Consumer Electronics, Industrial automation and Automotive. The leading position of the company in the industry is backed with the beneficial product range that is widely demanded in the industry for its rugged design, accurate and precise performance, hassle free operation, reliable performance and maintenance free service life.",
                       image: "/images/incubatees/cover/2.png",
        logo: "/images/incubatees/2.png"
    },
    {
      id: 3,
      title: "Avatar Aviation & Aerospace Private Limited",
      description: "Avatar Aviation has spread its wings across the length and breadth of India and made several award-winning projects to Aeronautical/Mechanical students and served the Aeronautical Institutions. The company is promoted by a team of AMEs, Pilots and experienced engineers. They have re-furbished and supplied 2 and 5 seater aircrafts in ground running condition, re-engineered 28 Tumansky R-11, ASV-12 Turbojet, Turboprop, Lycoming and Continental piston engines.",
                   image: "/images/incubatees/cover/3.png",
       logo: "/images/incubatees/3.png"
    },
    {
      id: 4,
      title: "Bala Aatral Solutions Private Limited",
      description: "Bala Aatral Solutions is a deep tech AR/VR/Metaverse solutions company based out of Chennai. Established in 2017, Aatral has focused on providing industrial solutions for process operations, safety training, safety audits, induction training using virtual reality and augmented reality technologies. With 3 IDEX wins in its bag, Aatral is currently working with Indian army, Indian Air force and Indian Navy to provide solutions such as VR based helicopter simulator, Ground crew maintenance training using VR/AR and also real time troubleshooting using smart glasses incorporated with AI.",
               image: "/images/incubatees/cover/4.png",
         logo: "/images/incubatees/4.png"
    },
    {
      id: 5,
      title: "Dataspire Technologies Private Limited",
      description: "Dataspire Technologies Private Limited is Information Technology, Consulting and Outsourcing Company specializing in Database and Infrastructure Management. Founded by a group of enthusiastic professionals, Dataspire Technologies aims to provide Customer Satisfaction through its unique and customer centric way of consulting. We also offer productized applications and platforms that provide the necessary competitive and innovation edge to clients across industries in the area of Big Data and Custom application development. Our Database consulting offers end-to-end services from Creation, Migration, 24x7x365 Monitoring from remote or onsite, Disaster Recover, Network Management & Security. Our strengths are in our technical expertise in making use of latest technologies and tools to fullfill our commitment to quality and delivery.",
           image: "/images/incubatees/cover/5.png",
        logo: "/images/incubatees/5.png"
    },
    {
      id: 6,
      title: "DVIZIRA Private Limited",
      description: "This is a military systems R&D startup, incorporated in 2016. DVIZIRA focuses on to build the need of the hour technologies in the C4I systems to augment the soldiers' capabilities on the battlefield. The team packs an overall experience of 30+ years in broad spectrum of technology & management and mentored by a veteran of Indian army specialized in Counter Insurgency & Counter Terrorism operations. DVIZIRA is not just a technology startup, but will be a patrimony advancing towards distinctive solutions to cater to every conceivable requirement of defence forces.",
      image: "/images/incubatees/cover/6.png",
        logo: "/images/incubatees/6.png"
    },
  ];

 

  return (
    <div className="incubatees-section sec-ptb" >
      <div className="container">
        <div className="sec-content  text-center  mb-5">
          <h6 className="sec-sub-title">Our Incubates</h6>
          <h2 className="teamx-title ">
            Explore Our Incubates
          </h2>
        </div>
        <div className="row g-4">
          {incubateesData.map((incubee, index) => (
            <div 
              key={incubee.id} 
              className="col-md-4"
           
            >
              <div className="incubee-card">
                <div className="incubee-img-container">
                  <img src={incubee.image} alt={incubee.title} className="incubee-img" />
                  <div className="incubee-logo">
                    <img src={incubee.logo} alt={`${incubee.title} logo`} />
                  </div>
                </div>
                <div className="incubee-content">
                  <h3 className="incubee-title">{incubee.title}</h3>
                  <p className="incubee-description">{incubee.description}</p>
                
                </div>
              </div>
            </div>
          ))}
        </div>
      </div>
    </div>
  );
};

export default Incubatees;