import React, { useContext } from "react";
import { Container, Form, Button, Row, Col } from "react-bootstrap";
import { PropsContext } from "../../../context/PropsContext";
import { ToastContainer } from 'react-toastify';

const IndigenisationForm = () => {
  const {
    indigenisationformData,
    indigenisationformerrors,
    isindigenisationformSubmitting,
    isindigenisationformSuccess,
    indigenisationhandleChange,
    indigenisationhandleSubmit,
  } = useContext(PropsContext);
  return (
    <section className="indigenisation-form-main">
      <div className="dihub-super-container ">
        <Container>
          <div className="sec-content text-center mb-5">
            <h6 className="sec-sub-title">
              India's First Defence Innovation Hub
            </h6>
            <h2 className="teamx-title">
              Join us in boosting indigenous production of defence equipment
            </h2>
          </div>

          <Row className="justify-content-center">
            <Col lg={8}>
              <div className="dihub-form-container p-4 p-md-5">
                <Form onSubmit={indigenisationhandleSubmit}>
                  <Row>
                    <Col md={6}>
                      <Form.Group className="mb-4 dihub-form-group">
                        <Form.Label className="dihub-label">
                          Full Name <span className="dihub-">*</span>
                        </Form.Label>
                        <Form.Control
                          type="text"
                          name="name"
                          value={indigenisationformData.name}
                          onChange={indigenisationhandleChange}
                          placeholder="Enter your full name"
                          className={`dihub-input ${
                            indigenisationformerrors.name ? "is-invalid" : ""
                          }`}
                        />
                        {indigenisationformerrors.name && (
                          <div className="invalid-feedback">
                            {indigenisationformerrors.name}
                          </div>
                        )}
                      </Form.Group>
                    </Col>
                    <Col md={6}>
                      <Form.Group className="mb-4 dihub-form-group">
                        <Form.Label className="dihub-label">
                          Email <span className="dihub-">*</span>
                        </Form.Label>
                        <Form.Control
                          type="email"
                          name="email"
                          value={indigenisationformData.email}
                          onChange={indigenisationhandleChange}
                          placeholder="Enter your email"
                          className={`dihub-input ${
                            indigenisationformerrors.email ? "is-invalid" : ""
                          }`}
                        />
                        {indigenisationformerrors.email && (
                          <div className="invalid-feedback">
                            {indigenisationformerrors.email}
                          </div>
                        )}
                      </Form.Group>
                    </Col>
                  </Row>

                  <Row>
                    <Col md={6}>
                      <Form.Group className="mb-4 dihub-form-group">
                        <Form.Label className="dihub-label">
                          Phone Number <span className="dihub-">*</span>
                        </Form.Label>
                        <Form.Control
                          type="tel"
                          name="phone"
                          value={indigenisationformData.phone}
                          onChange={indigenisationhandleChange}
                          placeholder="Enter your phone number"
                          className={`dihub-input ${
                            indigenisationformerrors.phone ? "is-invalid" : ""
                          }`}
                        />
                        {indigenisationformerrors.phone && (
                          <div className="invalid-feedback">
                            {indigenisationformerrors.phone}
                          </div>
                        )}
                      </Form.Group>
                    </Col>
                    <Col md={6}>
                      <Form.Group className="mb-4 dihub-form-group">
                        <Form.Label className="dihub-label">
                          Organization/Company
                        </Form.Label>
                        <Form.Control
                          type="text"
                          name="organisation"
                          value={indigenisationformData.organisation}
                          onChange={indigenisationhandleChange}
                          placeholder="Enter organization name"
                          className={`dihub-input ${
                            indigenisationformerrors.organisation
                              ? "is-invalid"
                              : ""
                          }`}
                        />
                        {indigenisationformerrors.organisation && (
                          <div className="invalid-feedback">
                            {indigenisationformerrors.organisation}
                          </div>
                        )}
                      </Form.Group>
                    </Col>
                    <Col md={12}>
                      <Form.Group className="mb-4 dihub-form-group">
                        <Form.Label className="dihub-label">
                          Designation
                        </Form.Label>
                        <Form.Control
                          type="text"
                          name="designation"
                          value={indigenisationformData.designation}
                          onChange={indigenisationhandleChange}
                          placeholder="Enter your designation"
                          className={`dihub-input ${
                            indigenisationformerrors.designation
                              ? "is-invalid"
                              : ""
                          }`}
                        />
                        {indigenisationformerrors.designation && (
                          <div className="invalid-feedback">
                            {indigenisationformerrors.designation}
                          </div>
                        )}
                      </Form.Group>
                    </Col>
                  </Row>

                  <div className="text-center">
                    <Button
                      variant="primary"
                      type="submit"
                      className="dihub-submit-btn"
                      disabled={isindigenisationformSubmitting}
                    >
                      {isindigenisationformSubmitting
                        ? "Submitting..."
                        : "Submit Application"}
                    </Button>
                  </div>

                  {isindigenisationformSuccess && (
                    <div className="alert alert-success mt-3">
                      Your application has been submitted successfully!
                    </div>
                  )}
                </Form>
                <ToastContainer position="top-right" autoClose={3000} />
              </div>
            </Col>
          </Row>
        </Container>
      </div>
    </section>
  );
};

export default IndigenisationForm;
