import React, { useState } from "react";
import {
  FaHandshake,
  FaBullseye,
  FaMapMarkerAlt,
  FaCalendarAlt,
  FaUsers,
  FaFileContract,
  FaHistory,
  FaFlag,
  FaQuestionCircle,
  FaLightbulb,
  FaRocket
} from "react-icons/fa";

const IndigenisationPoints = () => {
  const [hoveredIndex, setHoveredIndex] = useState(null);

  const leftPoints = [
    {
      number: "01.",
      title: "Consultancy & Advice",
      description:
        "Implementing cost-effective measures to streamline operations, optimize processes.",
      link: "/service-single/Consultancy-&-Advice",
      icon: <FaHandshake />,
    },
    {
      number: "02.",
      title: "Objective",
      description:
        "To empower MSMEs/Entrepreneurs to register under DGQA for indigenization of components/spares and guide them in certification/supply to the Armed Forces.",
      icon: <FaBullseye />,
    },
    {
      number: "03.",
      title: "Location",
      description:
        "The DGQA Facilitation Cell has been established at CODISSIA (Coimbatore District Small Industries Association).",
      icon: <FaMapMarkerAlt />,
    },
    {
      number: "04.",
      title: "Operational Days",
      description:
        "The cell will function on Fridays & Saturdays at CODISSIA's city office.",
      icon: <FaCalendarAlt />,
    },
    {
      number: "05.",
      title: "Role of CDIIC",
      description:
        "The Coimbatore District Industries and Industrial Centre (CDIIC) will coordinate sessions with DGQA representatives to clarify doubts and guide vendors on further processing.",
      icon: <FaUsers />,
    },
    {
      number: "06.",
      title: "Opportunity for Vendors",
      description:
        "The center enables vendors to participate in tenders issued by Ministry of Defence (MoD) procurement agencies, including Ordnance Factories (OFB) and Defence PSUs (DPSUs).",
      icon: <FaFileContract />,
    },
  ];

  const rightPoints = [
    {
      number: "07.",
      title: "Background – MGO's Visit",
      description: "Lt. Gen. S. K. Upadhya (Master General of Ordnance, Indian Army) visited CODISSIA on 22nd February 2020 and highlighted the importance of indigenization.",
      icon: <FaHistory />,
    },
    {
      number: "08.",
      title: "Government Initiatives",
      description: "The government has introduced simplified policies to promote indigenization in defence manufacturing.",
      icon: <FaFlag />,
    },
    {
      number: "09.",
      title: "Need for Facilitation Center",
      description: "Lt. Gen. Upadhya emphasized the necessity of a center to address vendor queries related to defence supplies.",
      icon: <FaQuestionCircle />,
    },
    {
      number: "10.",
      title: "CODISSIA's Initiative",
      description: "CODISSIA proposed hosting a DGQA Facilitation Cell in its city office to assist industries in and around Coimbatore.",
      icon: <FaLightbulb />,
    },
    {
      number: "11.",
      title: "Establishment of the Cell",
      description: "DGQA accepted CODISSIA's offer, and the DGQA Facilitation Cell was officially launched on 22nd May 2020.",
      icon: <FaRocket />,
    },
  ];

  return (
    <section className="indigenisation-objectives">
      <div className="sec-content  text-center  mb-5">
            <h6 className="sec-sub-title">Our Objectives</h6>
            <h2 className="teamx-title  ">Explore What's Our Objectives</h2>
          </div>
      <div className="container">
        <div className="row">
          {/* Left Points Column */}
          <div className="col-lg-12 col-md-12">
        
               <div className="row justify-content-center">
              {leftPoints.map((point, index) => (
                <div className="col-lg-4 col-md-6 col-sm-12 mb-4 service-section" key={`left-${index}`}>
                  <div className="service-item">
                    <div className="service-top">
                      <div className="icon">{point.icon}</div>
                      <div className="service-text">
                        <h2>{point.number}</h2>
                        <h3>
                          {point.link ? (
                            <a href={point.link}>{point.title}</a>
                          ) : (
                            <span>{point.title}</span>
                          )}
                        </h3>
                      </div>
                    </div>
                    <p>{point.description}</p>
                  </div>
                </div>
              ))}
            </div>
          </div>
          
          {/* Right Points Column */}
          <div className="col-lg-12 col-md-12">
         
            <div className="row justify-content-center">
              {rightPoints.map((point, index) => (
                <div className="col-lg-4 col-md-6 col-sm-12 mb-4 service-section" key={`right-${index}`}>
                  <div className="service-item">
                    <div className="service-top">
                      <div className="icon">{point.icon}</div>
                      <div className="service-text">
                        <h2>{point.number}</h2>
                        <h3>{point.title}</h3>
                      </div>
                    </div>
                    <p>{point.description}</p>
                  </div>
                </div>
              ))}
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default IndigenisationPoints;