import React from "react";

import { Container, Row, Col } from "react-bootstrap";

const InnovationFeatures = () => {
  const features = [
    {
      title: "State-of-the-Art Infrastructure",
      description: "Advanced facilities for prototyping and testing.",
      imgSrc: "/images/innovation/features/1.jpg",
    },
    {
      title: "Funding Support",
      description: "Financial assistance for MSMEs and start-ups.",
      imgSrc: "/images/innovation/features/2.jpg",
    },
    {
      title: "Innovation Ecosystem",
      description: "Collaborative environment for defence solutions.",
      imgSrc: "/images/innovation/features/3.jpg",
    },
  ];

  return (
    <section className="innovation-features">
      <Container className="my-5">
        <div className="sec-content  text-center  mb-5">
          <h6 className="sec-sub-title text-white">Features</h6>
          <h2 className="teamx-title text-white ">
            Key Features Of Our Innovations
          </h2>
        </div>
        <Row>
          {features.map((feature, index) => (
            <Col key={index}sm={6} md={4} className="mb-4">
              <div className="feature-card position-relative overflow-hidden rounded shadow-lg">
                <div>
                  {/* Hidden image that appears on hover */}
                  <img
                    src={feature.imgSrc}
                    alt={feature.title}
                    className=""
                  />
                </div>

                {/* Always visible content */}
                <div className=" d-flex flex-column  p-2">
                  <div className="d-flex justify-content-between align-items-center">
                    <div className="feature-text">
                      <h4 className="mb-2 ">{feature.title}</h4>
                      <p className="mb-0 ">{feature.description}</p>
                    </div>
                  </div>
                </div>
              </div>
            </Col>
          ))}
        </Row>
      </Container>
    </section>
  );
};

export default InnovationFeatures;
