import React, { useContext } from "react";
import { PropsContext } from "../../../context/PropsContext";

const AnnouncementsList = () => {
  const { 
    formattedAnnouncements, 
    announcementsPagination, 
    fetchAnnouncementsData 
  } = useContext(PropsContext);

  const safeParseDate = (dateString) => {
    if (!dateString) return null;
    const date = new Date(dateString);
    return isNaN(date.getTime()) ? null : date;
  };

  const handlePageChange = (newPage) => {
    if (newPage < 1 || newPage > announcementsPagination.last_page) return;
    fetchAnnouncementsData(newPage);
  };

  return (
    <div className="container py-5">
      <div className="sec-content text-center mb-5">
        <h6 className="sec-sub-title">Announcements</h6>
        <h2 className="teamx-title">
          Let's explore our announcements and witness the progress in indigenous defence initiatives.
        </h2>
      </div>
      
      <div className="row">
        {formattedAnnouncements.length === 0 ? (
          <div className="col-12 text-center">
            <p>No announcements available.</p>
          </div>
        ) : (
          formattedAnnouncements.map((announcement, index) => {
            const startDate = safeParseDate(announcement.start_date);
            
            return (
              <div
                className="col-lg-4 col-md-6 col-sm-6 col-12 mb-4"
                key={announcement.id || index}
              >
                <div className="neon-card">
                  <div className="neon-img-wrapper">
                    <img
                      src={announcement.image}
                      alt={announcement.title || "Announcement"}
                      className="neon-img"
                      onError={(e) =>
                        (e.target.src = "https://placehold.co/600x400?text=No+Image")
                      }
                    />
                    <div className="neon-hover-glow" />
                  </div>

                  <div className="neon-content">
                    <div className="d-flex justify-content-between align-items-center">
                      <span className={`neon-status ${announcement.isActive ? "on" : "off"}`}>
                        {announcement.isActive ? "Active" : "Inactive"}
                      </span>
                    </div>

                    <h5 className="neon-title">{announcement.title}</h5>
                    <p className="neon-desc">{announcement.description}</p>
                  </div>
                </div>
              </div>
            );
          })
        )}
      </div>

      {/* Pagination */}
      {formattedAnnouncements.length > 0 && (
        <div className="pagination-wrapper text-center mt-4">
          <button
            className="btn btn-outline-secondary mx-1"
            onClick={() => handlePageChange(announcementsPagination.current_page - 1)}
            disabled={announcementsPagination.current_page === 1}
          >
            &laquo;
          </button>

          {[...Array(announcementsPagination.last_page)].map((_, i) => (
            <button
              key={i + 1}
              onClick={() => handlePageChange(i + 1)}
              className={`btn btn-sm mx-1 ${
                announcementsPagination.current_page === i + 1
                  ? "btn-primary"
                  : "btn-outline-primary"
              }`}
            >
              {i + 1}
            </button>
          ))}

          <button
            className="btn btn-outline-secondary mx-1"
            onClick={() => handlePageChange(announcementsPagination.current_page + 1)}
            disabled={announcementsPagination.current_page === announcementsPagination.last_page}
          >
            &raquo;
          </button>
        </div>
      )}
    </div>
  );
};

export default AnnouncementsList;