import React, { useContext, useState } from "react";
import { PropsContext } from "../../../context/PropsContext";
import { FaClock } from "react-icons/fa";

const EventSchedule = () => {
  const { 
    formattedEvents, 
    eventsPagination, 
    fetchEventsData 
  } = useContext(PropsContext);

  const handlePageChange = (newPage) => {
    if (newPage < 1 || newPage > eventsPagination.last_page) return;
    fetchEventsData(newPage);
  };

  return (
    <section className="events-main">
      <div className="container-fluid py-5">
        <div className="sec-content text-center mb-5">
          <h6 className="sec-sub-title">Events</h6>
          <h2 className="teamx-title">
            Let's explore our events and witness the progress in indigenous defence initiatives.
          </h2>
        </div>
        
        {formattedEvents.length === 0 ? (
          <div className="text-center py-5">
            <h5>No events found</h5>
            <p className="text-muted">Please check back later for upcoming events</p>
          </div>
        ) : (
          formattedEvents.map((event, index) => (
            <div key={event.id} className="row event-block">
              <div className="col-12 col-sm-4 col-md-6 col-lg-2 date-block">
                <h2 className="event-date mb-0">{event.date}</h2>
                <p className="text-muted">{event.day}</p>
                <div>
                  <span className="tag">{event.status}</span>
                </div>
              </div>

              <div className="col-12 col-sm-8 col-md-6 col-lg-3 mb-3 event-block-info">
                <h5 className="fw-700">{event.title}</h5>
                <p className="text-muted">{event.subtitle}</p>
              </div>

              {/* Conditionally swap columns based on index */}
              {index % 2 === 0 ? (
                <>
                  <div className="col-md-6 col-lg-3 mt-3 d-flex flex-column align-items-start programs-image">
                    <img src={event.image} alt={event.title} className="img-fluid" />
                  </div>
                  <div className="col-md-6 col-lg-3 d-flex flex-column align-items-start mt-3 mb-3">
                    <div className="credits">
                      {event.credits.map((credit, i) => (
                        <div key={i} className={credit.className}>
                          {credit.icon}
                          <span className="credit-text">{credit.text}</span>
                        </div>
                      ))}
                      <div className="event-time">
                        <FaClock className="time-icon" />
                        <span className="time-text">{event.time}</span>
                      </div>
                    </div>
                  </div>
                </>
              ) : (
                <>
                  <div className="col-md-6 col-lg-3 d-flex flex-column align-items-start">
                    <div className="credits">
                      {event.credits.map((credit, i) => (
                        <div key={i} className={credit.className}>
                          {credit.icon}
                          <span className="credit-text">{credit.text}</span>
                        </div>
                      ))}
                      <div className="event-time">
                        <FaClock className="time-icon" />
                        <span className="time-text">{event.time}</span>
                      </div>
                    </div>
                  </div>
                  <div className="col-md-6 col-lg-3 d-flex flex-column align-items-start programs-image mt-3 mb-3">
                    <img src={event.image} alt={event.title} className="img-fluid" />
                  </div>
                </>
              )}
            </div>
          ))
        )}

        {/* Pagination */}
        {formattedEvents.length > 0 && (
          <div className="pagination-wrapper text-center mt-4">
            <button
              className="btn btn-outline-secondary mx-1"
              onClick={() => handlePageChange(eventsPagination.current_page - 1)}
              disabled={eventsPagination.current_page === 1}
            >
              &laquo;
            </button>

            {[...Array(eventsPagination.last_page)].map((_, i) => (
              <button
                key={i + 1}
                onClick={() => handlePageChange(i + 1)}
                className={`btn btn-sm mx-1 ${
                  eventsPagination.current_page === i + 1
                    ? "btn-primary"
                    : "btn-outline-primary"
                }`}
              >
                {i + 1}
              </button>
            ))}

            <button
              className="btn btn-outline-secondary mx-1"
              onClick={() => handlePageChange(eventsPagination.current_page + 1)}
              disabled={eventsPagination.current_page === eventsPagination.last_page}
            >
              &raquo;
            </button>
          </div>
        )}
      </div>
    </section>
  );
};

export default EventSchedule;