import "swiper/css";
import "swiper/css/navigation";
import { Navigation } from "swiper/modules";
import { Swiper, SwiperSlide } from "swiper/react";
import { production } from "../../../data/site";
import TeamCard from "../../ui/cards/TeamCard";

export default function Team() {
  return (
    <section className="team-sec sec-ptb team-members ">
      <div className="container">
        <div className="row">
          <div className="col-lg-6">
            <div className="sec-content">
              <h6 className="sec-sub-title">Our Production Team</h6>
              <h2 className="teamx-title">
               Our Production Team are committed, collaborative, and purpose-driven.
              </h2>
            </div>
          </div>
        </div>
        <div className="row">
          <div className="col">
            {/* team slider card part start */}
            <div className="team-slider position-relative pt-5">
              <Swiper
                spaceBetween={30}
                navigation={{
                  nextEl: ".owl-next",
                  prevEl: ".owl-prev",
                }}
                modules={[Navigation]}
                breakpoints={{
                  0: {
                    slidesPerView: 1,
                  },
                  425: {
                    slidesPerView: 2,
                  },
                  767: {
                    slidesPerView: 2,
                  },
                  992: {
                    slidesPerView: 4,
                  },
                }}
                loop={true}
              >
                {production.map((item, i) => (
                  <SwiperSlide key={i}>
                    <TeamCard data={item} />
                  </SwiperSlide>
                ))}
              </Swiper>

              <div className="owl-nav">
                <a
                  href="#"
                  onClick={(e) => e.preventDefault()}
                  className="owl-prev"
                >
                  <i className="flaticon-left-arrow" />
                </a>
                <a
                  href="#"
                  onClick={(e) => e.preventDefault()}
                  className="owl-next"
                >
                  <i className="flaticon-right-arrow" />
                </a>
              </div>
            </div>
            {/* team slider card part end */}
          </div>
        </div>
      </div>
    </section>
  );
}
