import { directors, exdirectors, members } from "../../../data/site";
import TeamCard from "../../ui/cards/TeamCard";
import TeamDirectors from "../../ui/cards/TeamDirectors";
import TeamMembers from "../../ui/cards/TeamMembers";
import { useState } from "react"; // Don't forget to import useState

export default function TeamInfo() {
  const [activeTab, setActiveTab] = useState("directors"); // 'directors', 'exdirectors', 'members'

  const renderContent = () => {
    switch (activeTab) {
      case "directors":
        return (
          <div className="row justify-content-center tab-content-animation">
            {directors.map((item, i) => (
              <div
                key={i}
                className="teamx-card-wrapper col-lg-3 col-md-4 col-sm-6 col-6 mb-4"
              >
                <TeamCard data={item} />
              </div>
            ))}
          </div>
        );
      case "exdirectors":
        return (
          <div className="row justify-content-center tab-content-animation">
            {exdirectors.map((item, i) => (
              <div
                key={i}
                className="teamx-card-wrapper col-lg-3 col-md-4 col-sm-6 col-6 mb-4"
              >
                <TeamDirectors data={item} />
              </div>
            ))}
          </div>
        );
      case "members":
        return (
          <div className="row justify-content-center tab-content-animation">
            {members.map((item, i) => (
              <div
                key={i}
                className="teamx-card-wrapper col-lg-3 col-md-4 col-sm-6 col-6 mb-4"
              >
                <TeamMembers data={item} />
              </div>
            ))}
          </div>
        );
      default:
        return null;
    }
  };

  return (
    <section className="teamx-section">
      <div className="teamx-container">
        {/* Tab Navigation */}
        <div className="teamx-tabs-navigation">
          <button
            className={`teamx-tab-link ${activeTab === "directors" ? "active" : ""}`}
            onClick={() => setActiveTab("directors")}
          >
            Our Directors
          </button>
          <button
            className={`teamx-tab-link ${activeTab === "exdirectors" ? "active" : ""}`}
            onClick={() => setActiveTab("exdirectors")}
          >
            Our Ex-Directors
          </button>
          <button
            className={`teamx-tab-link ${activeTab === "members" ? "active" : ""}`}
            onClick={() => setActiveTab("members")}
          >
            Our Members
          </button>
          <span className="teamx-tab-indicator"></span> {/* The animated underline */}
        </div>

        {/* Tab Content */}
        <div className="teamx-tab-content-wrapper">
          <div className="teamx-header">
            <h6 className="teamx-subtitle">
              {activeTab === "directors" && "Our Directors"}
              {activeTab === "exdirectors" && "Our Ex-Directors"}
              {activeTab === "members" && "Our Members"}
            </h6>
            <h2 className="teamx-title">
              {activeTab === "directors" &&
                "Our directors are visionary leaders driving innovation and growth."}
              {activeTab === "exdirectors" &&
                "Our ex-directors have laid the foundation for our success."}
              {activeTab === "members" &&
                "Our members are dedicated individuals contributing to our mission."}
            </h2>
          </div>
          {renderContent()}
        </div>
      </div>
    </section>
  );
}