import React, { useContext } from "react";
import { Container, Form, Button, Row, Col } from "react-bootstrap";
import { PropsContext } from "../../context/PropsContext";

const GetAQuote = () => {
  const {
    contactData,
    contactErrors,
    isSubmitting,
    submitSuccess,
    contactDatahandleChange,
    contactDatahandleSubmit,
  } = useContext(PropsContext);

  return (
    <div className="dihub-super-container">
      <Container>
        <div className="mb-5">
          <h6 className="sec-sub-title">Send Us A Message</h6>
          <h2 className="teamx-title">
            Do you have any questions? Any quries, Feel free to contact us
          </h2>
        </div>

        <Row className="justify-content-center">
          <Col lg={12}>
            <div className="dihub-form-container ">
              <Form onSubmit={contactDatahandleSubmit}>
                <Row>
                  <Col md={12}>
                    <Form.Group className="mb-4 dihub-form-group">
                      <Form.Label className="dihub-label">
                        Name <span className="dihub-">*</span>
                      </Form.Label>
                      <Form.Control
                        type="text"
                        name="name"
                        value={contactData.name}
                        onChange={contactDatahandleChange}
                        placeholder="Enter your last name"
                        className={`dihub-input ${
                          contactErrors.name ? "is-invalid" : ""
                        }`}
                      />
                      {contactErrors.name && (
                        <div className="invalid-feedback">
                          {contactErrors.name}
                        </div>
                      )}
                    </Form.Group>
                  </Col>
                </Row>

                <Row>
                  <Col md={12}>
                    <Form.Group className="mb-4 dihub-form-group">
                      <Form.Label className="dihub-label">
                        Email <span className="dihub-">*</span>
                      </Form.Label>
                      <Form.Control
                        type="email"
                        name="email"
                        value={contactData.email}
                        onChange={contactDatahandleChange}
                        placeholder="Enter your email"
                        className={`dihub-input ${
                          contactErrors.email ? "is-invalid" : ""
                        }`}
                      />
                      {contactErrors.email && (
                        <div className="invalid-feedback">
                          {contactErrors.email}
                        </div>
                      )}
                    </Form.Group>
                  </Col>
                </Row>

                <Row>
                  <Col md={12}>
                    <Form.Group className="mb-4 dihub-form-group">
                      <Form.Label className="dihub-label">
                        Phone <span className="dihub-">*</span>
                      </Form.Label>
                      <Form.Control
                        type="text"
                        name="phone"
                        value={contactData.phone}
                        onChange={contactDatahandleChange}
                        placeholder="Enter subject"
                        className={`dihub-input ${
                          contactErrors.phone ? "is-invalid" : ""
                        }`}
                      />
                      {contactErrors.phone && (
                        <div className="invalid-feedback">
                          {contactErrors.phone}
                        </div>
                      )}
                    </Form.Group>
                  </Col>

                  <Col md={12}>
                    <Form.Group className="mb-4 dihub-form-group">
                      <Form.Label className="dihub-label">Message</Form.Label>
                      <Form.Control
                        as="textarea"
                        name="message"
                        rows={4}
                        value={contactData.message}
                        onChange={contactDatahandleChange}
                        placeholder="Enter your message"
                        className={`dihub-input ${
                          contactErrors.message ? "is-invalid" : ""
                        }`}
                      />
                      {contactErrors.message && (
                        <div className="invalid-feedback">
                          {contactErrors.message}
                        </div>
                      )}
                    </Form.Group>
                  </Col>
                </Row>

                <div className="text-center">
                  <Button
                    variant="primary"
                    type="submit"
                    className="dihub-submit-btn"
                    disabled={isSubmitting}
                  >
                    {isSubmitting ? "Submitting..." : "Send Message"}
                  </Button>
                </div>

                {submitSuccess && (
                  <div className="alert alert-success mt-3">
                    Your message has been submitted successfully!
                  </div>
                )}
              </Form>
            </div>
          </Col>
        </Row>
      </Container>
    </div>
  );
};

export default GetAQuote;
