import { Link } from "react-router-dom";

const data = [
  {
    title: "ARMY",
    imgUrl: "/images/team/defence/1.jpg",
    link: "/army",
    des: "Land-based military operations and ground defense.",
  },
  {
    title: "NAVY",
    imgUrl: "/images/team/defence/2.jpg",
    link: "/navy",
    des: "Naval warfare and maritime security.",
  },
  {
    title: "AIRFORCE",
    imgUrl: "/images/team/defence/3.jpg",
    link: "/airforce",
    des: "Aerial operations, air superiority, and support.",
  },
  {
    title: "DPSUs",
    imgUrl: "/images/team/defence/4.jpg",
    link: "/dpsus",
    des: "Defence Public Sector Undertakings supporting military infrastructure.",
  },
];

export default function DefenceCardGrid() {
  return (
    <section className="sec-ptb">
      <div className="container">
        <div className="sec-content text-center mb-3">
          <h6 className="sec-sub-title">Partner - Defence</h6>
          <h2 className="teamx-title">
            Defence Partnerships: Paving the Way for Self-Reliance and
            Innovation
          </h2>
        </div>
        <div className="defence-grid-container">
          {data.map((item, index) => (
            <div className="defence-grid-item" key={index}>
              <div className="defence-card-image">
                <img src={item.imgUrl} alt={item.title} />
                <div className="defence-overlay">
                  <h3>{item.title}</h3>
                  <p>{item.des}</p>
                </div>
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
}
