

import { Link } from "react-router-dom";

export default function GalleryCard({ data, index }) {
  return (
    <div
      className="single-project single-project-style2 wow fadeInUp"
      data-wow-delay={`${index * 100}ms`}
      data-wow-duration="1000ms"
    >
      <div className="project-img" id="gallery-img">
        <img 
          src={data.imageUrl || data.image}
          alt={data.title}
          className="h-100 w-100"
          loading="lazy"
          onError={(e) => {
            e.target.onerror = null; 
            e.target.src = '/path/to/fallback-image.jpg';
          }}
        />
      </div>
      <div className="project-title">
        <h5>{data.title}</h5>
      </div>
    </div>
  );
}
