import "swiper/css";
import "swiper/css/navigation";
import { Navigation } from "swiper/modules";
import { Swiper, SwiperSlide } from "swiper/react";
import { partners } from "../../../data/site";

export default function PartnerCard() {
  return (
    <>
      <section className="partner-section sec-ptb">
        <div className="container">
          <div className="sec-content text-center mb-4">
            <h6 className="sec-sub-title text-white">Partner - Academic</h6>
            <h2 className="teamx-title text-white">
              The Role of Academia in Defence Partnerships
            </h2>
          </div>

          <div className="partner-carousel-wrapper">
            <Swiper
              spaceBetween={30}
              navigation={{
                nextEl: ".partner-next",
                prevEl: ".partner-prev",
              }}
              modules={[Navigation]}
              breakpoints={{
                0: { slidesPerView: 1 },
                425: { slidesPerView: 1 },
                767: { slidesPerView: 2 },
                992: { slidesPerView: 4 },
              }}
              loop={true}
            >
              {partners.map((item, i) => (
                <SwiperSlide key={i}>
                  <div className="partner-card">
                    <img
                      src={item.imgUrl}
                      alt={item.imgUrl}
                      className="partner-image"
                    />
                    <h4 className="partner-name">{item.title}</h4>
                    <p className="partner-description">{item.des}</p>
                  </div>
                </SwiperSlide>
              ))}
            </Swiper>

            <div className="partner-navigation">
              <button className="partner-prev">
                <i className="flaticon-left-arrow" />
              </button>
              <button className="partner-next">
                <i className="flaticon-right-arrow" />
              </button>
            </div>
          </div>
        </div>
      </section>
      {/* Psg Step */}
      <section>
        <div className="container sec-ptb">
          <div className="row">
            <div className="col-12">
              <div className="sec-content text-center ">
                <h6 className="sec-sub-title mb-4">
                  Partner - Incubation Center
                </h6>
                <div className="mb-4 partner-card partners-main">
                  <img
                    className="img-fluid"
                    src="/images/team/partners/partnerstep.png"
                    alt=""
                    srcset=""
                  />
                </div>
                <div className="partner-team">
                  <h2 className="teamx-title ">
                    <a target="_balnk" href="http://www.psgstep.org/">
                      PSG-Science & Technology Entrepreneurial Park (PSG-STEP)
                    </a>
                  </h2>
                  <p className="text-center">
                    PSG College of Technology,Avinashi Road, Peelamedu,
                    Coimbatore - 641 004
                  </p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
}
