import { Link } from "react-router-dom";

const social = [
  {
    name: "facebook",
    link: "http://facebook.com",
    icon: "fa-brands fa-facebook-f",
  },
  {
    name: "twitter",
    link: "http://twitter.com",
    icon: "fa-brands fa-twitter",
  },
  {
    name: "instagram",
    link: "http://instagram.com",
    icon: "fa-brands fa-instagram",
  },
  {
    name: "linkedin",
    link: "http://linkedin.com",
    icon: "fa-brands fa-linkedin-in",
  },
];

export default function TeamCard({ data }) {
  return (
    <>
      <div className="minimal-team-card">
        <div className="minimal-member-img-wrap">
          <img src={data.imgUrl} alt="team" />
        </div>
        <ul className="minimal-social-list">
          {social?.map((item, i) => (
            <li key={i}>
              <Link
                className="minimal-social-link"
                to={item.link}
                target="_blank"
              >
                <i className={item.icon} />
              </Link>
            </li>
          ))}
        </ul>
        <div className="minimal-member-details">
          <h3 className="minimal-member-name">{data.title}</h3>
          <span className="minimal-member-category">{data.category}</span>
        </div>
      </div>
    </>
  );
}
